/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.login;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.controller.ServerController;
import org.ut.biolab.medsavant.client.view.component.NiceMenu;
import org.ut.biolab.medsavant.client.view.list.DetailedListModel;
import org.ut.biolab.medsavant.client.view.list.SplitScreenView;
import org.ut.biolab.medsavant.client.view.login.MedSavantServerInfo;
import org.ut.biolab.medsavant.client.view.login.ServerDetailedListEditor;
import org.ut.biolab.medsavant.client.view.login.ServerDetailedView;
import org.ut.biolab.medsavant.client.view.login.SplashFrame;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class SplashServerManagementComponent
extends JPanel
implements Listener<ServerController> {
    private NiceMenu topMenu;
    private SplitScreenView serverListScreen;
    private ServerDetailedView serverDetailView;
    private SplashFrame splash;

    public SplashServerManagementComponent(SplashFrame splash) {
        this.splash = splash;
        this.initUI();
        ServerController.getInstance().addListener(this);
    }

    public SplitScreenView getServerList() {
        return this.serverListScreen;
    }

    private void initUI() {
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.topMenu = new NiceMenu();
        this.topMenu.setTitle("Server Management");
        this.add((Component)this.topMenu, "North");
        JPanel container = ViewUtil.getClearPanel();
        container.setLayout((LayoutManager)new MigLayout("insets 0, fillx, filly, center, hidemode 3"));
        this.add((Component)container, "Center");
        this.serverDetailView = new ServerDetailedView(this.splash, this);
        ServerDetailedListEditor serverDetailListEditor = new ServerDetailedListEditor(this);
        this.serverListScreen = new SplitScreenView(new DetailedListModel(){

            @Override
            public Object[][] getList(int limit) throws Exception {
                List<MedSavantServerInfo> servers = ServerController.getInstance().getServers();
                Object[][] results = new Object[servers.size()][];
                int counter = 0;
                for (MedSavantServerInfo server : servers) {
                    results[counter++] = new Object[]{server.getNickname(), server};
                }
                return results;
            }

            @Override
            public String[] getColumnNames() {
                return new String[]{"Server", "ServerObject"};
            }

            @Override
            public Class[] getColumnClasses() {
                return new Class[]{String.class, MedSavantServerInfo.class};
            }

            @Override
            public int[] getHiddenColumns() {
                return new int[0];
            }
        }, this.serverDetailView, serverDetailListEditor);
        container.add((Component)this.serverListScreen, "width 100%, height 100%");
    }

    public void addServerAndEdit() {
        String baseName;
        String newName = baseName = "Untitled Server";
        int counter = 1;
        while (ServerController.getInstance().isServerNamed(newName)) {
            newName = String.format("%s (%d)", baseName, ++counter);
        }
        MedSavantServerInfo server = new MedSavantServerInfo();
        server.setNickname(newName);
        ServerController.getInstance().addServer(server);
        this.setSelectedServer(server);
    }

    private void setSelectedServer(MedSavantServerInfo server) {
        this.serverListScreen.selectItemWithKey(server.getNickname());
    }

    @Override
    public void handleEvent(ServerController event) {
        this.refreshList();
    }

    private void refreshList() {
        this.serverListScreen.refresh();
    }
}

