/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.util;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public class VerticalLabelUI
extends BasicLabelUI {
    protected boolean clockwise;
    private static Rectangle paintIconR;
    private static Rectangle paintTextR;
    private static Rectangle paintViewR;
    private static Insets paintViewInsets;

    public VerticalLabelUI(boolean clockwise) {
        this.clockwise = clockwise;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        return new Dimension(dim.height, dim.width);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        paintViewInsets = c.getInsets(paintViewInsets);
        VerticalLabelUI.paintViewR.x = VerticalLabelUI.paintViewInsets.left;
        VerticalLabelUI.paintViewR.y = VerticalLabelUI.paintViewInsets.top;
        VerticalLabelUI.paintViewR.height = c.getWidth() - (VerticalLabelUI.paintViewInsets.left + VerticalLabelUI.paintViewInsets.right);
        VerticalLabelUI.paintViewR.width = c.getHeight() - (VerticalLabelUI.paintViewInsets.top + VerticalLabelUI.paintViewInsets.bottom);
        VerticalLabelUI.paintIconR.height = 0;
        VerticalLabelUI.paintIconR.width = 0;
        VerticalLabelUI.paintIconR.y = 0;
        VerticalLabelUI.paintIconR.x = 0;
        VerticalLabelUI.paintTextR.height = 0;
        VerticalLabelUI.paintTextR.width = 0;
        VerticalLabelUI.paintTextR.y = 0;
        VerticalLabelUI.paintTextR.x = 0;
        String clippedText = this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform tr = g2.getTransform();
        if (this.clockwise) {
            g2.rotate(1.5707963267948966);
            g2.translate(0, -c.getWidth());
        } else {
            g2.rotate(-1.5707963267948966);
            g2.translate(-c.getHeight(), 0);
        }
        if (icon != null) {
            icon.paintIcon(c, g, VerticalLabelUI.paintIconR.x, VerticalLabelUI.paintIconR.y);
        }
        if (text != null) {
            int textX = VerticalLabelUI.paintTextR.x;
            int textY = VerticalLabelUI.paintTextR.y + fm.getAscent();
            if (label.isEnabled()) {
                this.paintEnabledText(label, g, clippedText, textX, textY);
            } else {
                this.paintDisabledText(label, g, clippedText, textX, textY);
            }
        }
        g2.setTransform(tr);
    }

    static {
        labelUI = new VerticalLabelUI(false);
        paintIconR = new Rectangle();
        paintTextR = new Rectangle();
        paintViewR = new Rectangle();
        paintViewInsets = new Insets(0, 0, 0, 0);
    }
}

