/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.SourceListBadgeContentProvider;
import com.explodingpixels.widgets.IconProvider;
import com.explodingpixels.widgets.TextProvider;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class SourceListItem
implements TextProvider,
IconProvider,
SourceListBadgeContentProvider {
    public static final String TEXT = "text";
    public static final String ICON = "icon";
    public static final String COUNTER_VALUE = "counter";
    private List<SourceListItem> fChildItems = new ArrayList<SourceListItem>();
    private String fText;
    private Icon fIcon;
    private int fCounterValue;
    private PropertyChangeSupport fSupport = new PropertyChangeSupport(this);

    public SourceListItem(String text) {
        this(text, null);
    }

    public SourceListItem(String text, Icon icon) {
        this.checkText(text);
        this.fText = text;
        this.fIcon = icon;
    }

    @Override
    public String getText() {
        return this.fText;
    }

    public void setText(String text) {
        this.checkText(text);
        String oldText = this.fText;
        this.fText = text;
        this.fSupport.firePropertyChange(TEXT, oldText, this.fText);
    }

    @Override
    public Icon getIcon() {
        return this.fIcon;
    }

    public void setIcon(Icon icon) {
        Icon oldIcon = this.fIcon;
        this.fIcon = icon;
        this.fSupport.firePropertyChange(ICON, oldIcon, this.fIcon);
    }

    boolean hasCounterValue() {
        return this.getCounterValue() > 0;
    }

    @Override
    public int getCounterValue() {
        return this.fCounterValue;
    }

    public void setCounterValue(int counterValue) {
        this.checkCount(counterValue);
        int oldCounterValue = this.fCounterValue;
        this.fCounterValue = counterValue;
        this.fSupport.firePropertyChange(COUNTER_VALUE, oldCounterValue, this.fCounterValue);
    }

    public boolean containsItem(SourceListItem item) {
        boolean contains;
        block1: {
            SourceListItem childItem;
            contains = this.fChildItems.contains(item);
            if (contains) break block1;
            Iterator<SourceListItem> i$ = this.fChildItems.iterator();
            while (i$.hasNext() && !(contains = (childItem = i$.next()).containsItem(item))) {
            }
        }
        return contains;
    }

    public String toString() {
        return this.getText();
    }

    public List<SourceListItem> getChildItems() {
        return Collections.unmodifiableList(this.fChildItems);
    }

    int indexOfItem(SourceListItem item) {
        return this.fChildItems.indexOf(item);
    }

    int getChildCount() {
        return this.fChildItems.size();
    }

    void addItem(SourceListItem childItem) {
        this.fChildItems.add(childItem);
    }

    void addItem(int index, SourceListItem childItem) {
        this.fChildItems.add(index, childItem);
    }

    void removeItem(SourceListItem childItem) {
        this.fChildItems.remove(childItem);
    }

    SourceListItem removeItem(int index) {
        return this.fChildItems.remove(index);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.fSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.fSupport.removePropertyChangeListener(listener);
    }

    private void checkCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be zero or greater.");
        }
    }

    private void checkText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null.");
        }
    }
}

