/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeListener;
import pedviz.algorithms.Algorithm;
import pedviz.graph.Edge;
import pedviz.graph.Graph;
import pedviz.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FamilySplitter
implements Algorithm {
    private HashMap<Integer, Set<Integer>> famSet = new HashMap();
    private Graph graph;
    private ArrayList<Graph> result;
    private ChangeListener changeListener;
    private int percent = 0;

    public FamilySplitter(Graph graph) {
        this.graph = graph;
        this.result = new ArrayList();
    }

    @Override
    public String getMessage() {
        return "Search Families...";
    }

    @Override
    public void run() {
        this.splitInFamilies();
    }

    public ArrayList<Graph> getFamilies() {
        return this.result;
    }

    @Override
    public int getPercentComplete() {
        return this.percent;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    private void addFam(int oldRank, int newRank) {
        Set<Integer> newSet;
        Set<Integer> oldSet = this.famSet.get(newRank);
        if (oldSet != (newSet = this.famSet.get(oldRank))) {
            for (Integer i : oldSet) {
                newSet.add((int)i);
                this.famSet.put((int)i, newSet);
            }
            oldSet.clear();
        }
    }

    private void addFam(int newRank) {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(newRank);
        this.famSet.put(newRank, set);
    }

    private Collection<Graph> createFamList() {
        HashMap<Integer, Graph> families = new HashMap<Integer, Graph>();
        HashMap<Integer, Integer> idfam = new HashMap<Integer, Integer>();
        int c = 0;
        for (Set<Integer> set : this.famSet.values()) {
            for (Integer i : set) {
                idfam.put(i, c);
            }
            set.clear();
            ++c;
        }
        this.famSet.clear();
        for (Node node : this.graph.getNodes()) {
            Integer id = (Integer)idfam.get(node.getFamilieRank());
            Graph family = (Graph)families.get(id);
            if (family == null) {
                family = new Graph();
                families.put(id, family);
            }
            family.addNode(node);
            for (Edge out : node.getInEdges()) {
                family.addEdge(out, false);
            }
        }
        return families.values();
    }

    private void splitInFamilies() {
        int familyRank = 0;
        int total = this.graph.getNodes().size();
        int current = 0;
        for (Node node : this.graph.getNodes()) {
            this.fireChangeListener(Math.round(current * 100 / total));
            ++current;
            if (node.getFamilieRank() < 0) {
                this.addFam(familyRank);
                node.setFamilieRank(familyRank);
                for (Edge edge : node.getOutEdges()) {
                    if (edge.getEnd().getFamilieRank() < 0) {
                        edge.getEnd().setFamilieRank(familyRank);
                        continue;
                    }
                    Integer oldRank = edge.getEnd().getFamilieRank();
                    this.addFam(oldRank, familyRank);
                }
            } else {
                Integer myRank = node.getFamilieRank();
                for (Edge edge : node.getOutEdges()) {
                    if (edge.getEnd().getFamilieRank() < 0) {
                        edge.getEnd().setFamilieRank(myRank);
                        continue;
                    }
                    Integer oldRank = edge.getEnd().getFamilieRank();
                    if (oldRank == myRank) continue;
                    this.addFam(myRank, oldRank);
                }
            }
            ++familyRank;
        }
        this.result.clear();
        this.result.addAll(this.createFamList());
        Collections.sort(this.result, new Comparator<Graph>(){

            @Override
            public int compare(Graph arg0, Graph arg1) {
                return new Integer(arg1.getNodes().size()).compareTo(arg0.getNodes().size());
            }
        });
    }

    private void fireChangeListener(int percent) {
        if (this.changeListener != null) {
            this.percent = percent;
            this.changeListener.stateChanged(null);
        }
    }
}

