/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.ChangeListener;
import pedviz.algorithms.Algorithm;
import pedviz.graph.Edge;
import pedviz.graph.LayoutedGraph;
import pedviz.graph.Node;
import pedviz.view.DefaultNodeView;
import pedviz.view.NodeView;

public class RubberBands
implements Algorithm {
    private LayoutedGraph graph;
    private float horizontalSpacing = 20.0f;
    private float depth = 100.0f;
    private int nodeSize = 7;
    private float verticalSpacing = 25.0f;
    private int horizontalGap = 1;
    private int maxIterations = 200;
    private ChangeListener changeListener;
    private int percent = 0;

    public RubberBands(LayoutedGraph graph) {
        this.graph = graph;
    }

    public void run() {
        int i;
        if (this.graph.getGraph() == null) {
            System.out.println("oje");
        }
        for (i = 0; i < this.graph.getGraph().getHierachiesCount(); ++i) {
            this.init(i);
        }
        for (i = 0; i < this.graph.getGraph().getHierachiesCount(); ++i) {
            for (int j = 0; j < this.maxIterations; ++j) {
                this.fireChangeListener(Math.round((float)j / 2.0f));
                this.rubberBands(i);
            }
        }
        this.calcPosForSubnodes();
        this.centerGraph();
    }

    public String getMessage() {
        return "Calc Positions...";
    }

    public int getPercentComplete() {
        return this.percent;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public float getDepth() {
        return this.depth;
    }

    public void setDepth(float depth) {
        this.depth = depth;
    }

    public float getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(float minimumX) {
        this.horizontalSpacing = minimumX;
    }

    public int getNodeSize() {
        return this.nodeSize;
    }

    public void setNodeSize(int nodeSize) {
        this.nodeSize = nodeSize;
    }

    public float getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(float height) {
        this.verticalSpacing = height;
    }

    public int getHorizontalGap() {
        return this.horizontalGap;
    }

    public void setHorizontalGap(int gap) {
        this.horizontalGap = gap;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    private void init(int id) {
        for (Integer i : this.graph.getGraph().getHierachy(id).getNodes().keySet()) {
            ArrayList<Node> layer = this.graph.getGraph().getHierachy(id).getNodes(i);
            if (layer == null) continue;
            float currentX = 0.0f;
            for (int j = 0; j < layer.size(); ++j) {
                Node currentNode = layer.get(j);
                Object currentNodeView = this.graph.getNodeView(currentNode.getId());
                ((NodeView)currentNodeView).setPosX(currentX);
                ((NodeView)currentNodeView).setPosY((this.verticalSpacing + ((DefaultNodeView)currentNodeView).getHeight().floatValue()) * (float)i.intValue());
                ((NodeView)currentNodeView).setPosZ((float)id * this.depth);
                if (this.graph.getNodeView(currentNode.getIdMom()) != null && this.graph.getNodeView(currentNode.getIdDad()) != null) {
                    ((NodeView)currentNodeView).setMomLeft(((NodeView)this.graph.getNodeView(currentNode.getIdMom())).getPosY() < ((NodeView)this.graph.getNodeView(currentNode.getIdDad())).getPosY());
                }
                this.graph.setPosHierarchie(i, (this.verticalSpacing + ((DefaultNodeView)currentNodeView).getHeight().floatValue()) * (float)i.intValue());
                if (j + 1 >= layer.size()) continue;
                Node nextNode = layer.get(j + 1);
                Object nextNodeView = this.graph.getNodeView(nextNode.getId());
                float currentWidth = ((NodeView)currentNodeView).calcWidth(this.nodeSize, this.horizontalGap);
                float nextWidth = ((NodeView)nextNodeView).calcWidth(this.nodeSize, this.horizontalGap);
                currentX += this.horizontalSpacing + currentWidth / 2.0f + nextWidth / 2.0f;
            }
        }
    }

    private void rubberBands(int id) {
        for (Integer j : this.graph.getGraph().getHierachy(id).getNodes().keySet()) {
            ArrayList<Node> layer = this.graph.getGraph().getHierachy(id).getNodes(j);
            if (layer == null) continue;
            for (int k = 0; k < layer.size(); ++k) {
                float diffX;
                Node node = layer.get(k);
                Object nodeView = this.graph.getNodeView(node);
                float xPosNode = ((NodeView)nodeView).getPosX();
                double fRub = this.fRub(node);
                if (fRub < 0.0) {
                    Node leftNode = null;
                    float xPosLeft = -3.4028235E38f;
                    if (k - 1 >= 0) {
                        leftNode = layer.get(k - 1);
                        Object leftNodeView = this.graph.getNodeView(leftNode);
                        xPosLeft = ((NodeView)leftNodeView).getPosX();
                        diffX = (float)Math.min(Math.abs(fRub), (double)(xPosNode - xPosLeft - this.minDistance(leftNode, node)));
                        ((NodeView)nodeView).setPosX(xPosNode - diffX);
                        continue;
                    }
                    ((NodeView)nodeView).setPosX(xPosNode - (float)Math.abs(fRub));
                    continue;
                }
                Node rightNode = null;
                float xPosRight = Float.MAX_VALUE;
                if (k + 1 < layer.size()) {
                    rightNode = layer.get(k + 1);
                    Object rightNodeView = this.graph.getNodeView(rightNode.getId());
                    xPosRight = ((NodeView)rightNodeView).getPosX();
                    diffX = (float)Math.min(Math.abs(fRub), (double)(xPosRight - xPosNode - this.minDistance(node, rightNode)));
                    ((NodeView)nodeView).setPosX(xPosNode + diffX);
                    continue;
                }
                ((NodeView)nodeView).setPosX(xPosNode + (float)Math.abs(fRub));
            }
        }
    }

    private void calcPosForSubnodes() {
        float width;
        Object nodeview;
        Node node;
        Node o2;
        Iterator<Node> i$ = this.graph.getGraph().getNodes().iterator();
        while (i$.hasNext()) {
            node = o2 = i$.next();
            nodeview = this.graph.getNodeView(node.getId());
            width = ((NodeView)nodeview).calcWidth(this.nodeSize, this.horizontalGap);
            Object nodeView = this.graph.getNodeView(node.getId());
            float newPosX = ((NodeView)nodeView).getPosX() - width / 2.0f + (float)this.nodeSize / 2.0f;
            for (Node subNode : node.getNodes()) {
                Object subNodeView = this.graph.getNodeView(subNode.getId());
                ((NodeView)subNodeView).setPosX(newPosX);
                ((NodeView)subNodeView).setPosY(((NodeView)nodeView).getPosY());
                ((NodeView)subNodeView).setPosZ(((NodeView)nodeView).getPosZ());
                newPosX += (float)(this.horizontalGap + this.nodeSize);
            }
        }
        for (Node o2 : this.graph.getNodes()) {
            NodeView nodeview2 = (NodeView)((Object)o2);
            nodeview2.sortSubNodes();
        }
        i$ = this.graph.getGraph().getNodes().iterator();
        while (i$.hasNext()) {
            node = o2 = i$.next();
            nodeview = this.graph.getNodeView(node.getId());
            ((NodeView)nodeview).sortSubNodes();
            width = ((NodeView)nodeview).calcWidth(this.nodeSize, this.horizontalGap);
            float newPosX = ((NodeView)nodeview).getPosX() - width / 2.0f + (float)this.nodeSize / 2.0f;
            for (Node subNode : node.getNodes()) {
                Object subNodeView = this.graph.getNodeView(subNode.getId());
                ((NodeView)subNodeView).setPosX(newPosX);
                ((NodeView)subNodeView).setPosY(((NodeView)nodeview).getPosY());
                ((NodeView)subNodeView).setPosZ(((NodeView)nodeview).getPosZ());
                newPosX += (float)(this.horizontalGap + this.nodeSize);
            }
        }
    }

    private void centerGraph() {
        float diffx = this.graph.getBounds().width / 2.0f + this.graph.getBounds().x;
        float diffy = this.graph.getBounds().height / 2.0f + this.graph.getBounds().y;
        this.graph.setBounds(0.0f, 0.0f, 0.0f, 0.0f);
        for (Object nodeView2 : this.graph.getAllNodes().values()) {
            NodeView nodeView = (NodeView)nodeView2;
            nodeView.setPosX(nodeView.getPosX() - diffx);
            nodeView.setPosY(nodeView.getPosY() - diffy);
            nodeView.setPosZ(nodeView.getPosZ() - this.depth / 2.0f);
        }
    }

    private void fireChangeListener(int percent) {
        if (this.changeListener != null) {
            this.percent = percent;
            this.changeListener.stateChanged(null);
        }
    }

    private double fRub(Node node) {
        float sum = 0.0f;
        Object nodeView = this.graph.getNodeView(node.getId());
        for (Edge edge : node.getInEdges()) {
            Node start = edge.getStart();
            Object startNodeView = this.graph.getNodeView(start.getId());
            sum += ((NodeView)startNodeView).getPosX() - ((NodeView)nodeView).getPosX();
        }
        for (Edge edge : node.getOutEdges()) {
            Node end = edge.getEnd();
            Object endNodeView = this.graph.getNodeView(end.getId());
            sum += ((NodeView)endNodeView).getPosX() - ((NodeView)nodeView).getPosX();
        }
        if (node.getDegree() == 0) {
            return 0.0;
        }
        return sum / (float)node.getDegree();
    }

    private float minDistance(Node left, Node right) {
        if (left == null || right == null) {
            return 0.0f;
        }
        Object leftNodeView = this.graph.getNodeView(left.getId());
        Object rightNodeView = this.graph.getNodeView(right.getId());
        float leftWidth = ((NodeView)leftNodeView).calcWidth(this.nodeSize, this.horizontalGap);
        float rightWidth = ((NodeView)rightNodeView).calcWidth(this.nodeSize, this.horizontalGap);
        return this.horizontalSpacing + leftWidth / 2.0f + rightWidth / 2.0f;
    }

    public void updateYPosition() {
        this.graph.setBounds(this.graph.getBounds().x, 0.0f, this.graph.getBounds().width, 0.0f);
        for (int id = 0; id < this.graph.getGraph().getHierachiesCount(); ++id) {
            for (Integer i : this.graph.getGraph().getHierachy(id).getNodes().keySet()) {
                ArrayList<Node> layer = this.graph.getGraph().getHierachy(id).getNodes(i);
                if (layer == null) continue;
                for (int j = 0; j < layer.size(); ++j) {
                    Node node = layer.get(j);
                    Object currentNodeView = this.graph.getNodeView(node);
                    ((NodeView)currentNodeView).setPosY((this.verticalSpacing + ((DefaultNodeView)currentNodeView).getHeight().floatValue()) * (float)i.intValue());
                    this.graph.setPosHierarchie(i, (this.verticalSpacing + ((DefaultNodeView)currentNodeView).getHeight().floatValue()) * (float)i.intValue());
                    for (Node subNode : node.getNodes()) {
                        Object subNodeView = this.graph.getNodeView(subNode.getId());
                        ((NodeView)subNodeView).setPosY(((NodeView)currentNodeView).getPosY());
                    }
                }
            }
        }
        this.centerGraph();
    }
}

