/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms.magiceye;

import java.util.Vector;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import pedviz.graph.Node;
import pedviz.view.DefaultNodeView;
import pedviz.view.NodeView;

public class MagicEyeNodeView
extends NodeView {
    public MagicEyeNodeView parent;
    public MagicEyeNodeView leftSibling;
    public MagicEyeNodeView rightSibling;
    public Vector<MagicEyeNodeView> childs;
    public Vector<MagicEyeNodeView> crossedgeTargets;
    public Vector<String> crossedgeStrings;
    public Vector<MagicEyeNodeView> crossedgeTargetsNew;
    public Vector<String> crossedgeStringsNew;
    public Vector<MagicEyeNodeView> otherParents;
    public int numChilds;
    public int leaves;
    public int nodes;
    public int depth;
    public int level;
    public int num;
    public int strahlerNumber;
    public float edgeWidth;
    public Color3f edgeColor;
    public Color3f markedEdgeColor;
    public boolean visible;
    public boolean folded;
    public boolean marked;
    public boolean focused;
    public boolean atPathToRoot;
    public boolean partiallyFolded;
    public double x;
    public double xoffs;
    public double y;
    public double z;
    public double lambda;
    public double phi;
    public MagicEyeNodeView leftNeighbor;
    public double modifier;
    public double prelim;
    public Point3d[] pEdgePoints;
    public Point3d[] qEdgePoints;

    public MagicEyeNodeView(Node node, DefaultNodeView defaultNodeView) {
        super(node, defaultNodeView);
    }

    public void init(MagicEyeNodeView parent, int level, int num) {
        this.parent = parent;
        this.level = level;
        this.num = num;
        this.visible = true;
        this.folded = false;
        this.partiallyFolded = false;
        this.marked = false;
        this.focused = false;
        this.atPathToRoot = false;
        this.childs = new Vector();
        this.xoffs = 0.0;
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.pEdgePoints = new Point3d[9];
        this.qEdgePoints = new Point3d[9];
        for (int i = 0; i < 9; ++i) {
            this.pEdgePoints[i] = new Point3d();
            this.qEdgePoints[i] = new Point3d();
        }
        this.crossedgeTargets = new Vector();
        this.crossedgeStrings = new Vector();
        this.crossedgeTargetsNew = new Vector();
        this.crossedgeStringsNew = new Vector();
        this.otherParents = new Vector();
    }

    public MagicEyeNodeView getChild(int i) {
        return this.childs.get(i);
    }

    public boolean hasChild() {
        return this.numChilds > 0;
    }

    public boolean isLeaf() {
        return this.numChilds == 0 || this.folded;
    }

    public boolean hasLeftSibling() {
        return this.leftSibling() != null;
    }

    public MagicEyeNodeView leftSibling() {
        MagicEyeNodeView nl = this.leftSibling;
        while (nl != null) {
            if (nl.visible) {
                return nl;
            }
            nl = nl.leftSibling;
        }
        return null;
    }

    public boolean hasRightSibling() {
        return this.rightSibling() != null;
    }

    public MagicEyeNodeView rightSibling() {
        MagicEyeNodeView nr = this.rightSibling;
        while (nr != null) {
            if (nr.visible) {
                return nr;
            }
            nr = nr.rightSibling;
        }
        return null;
    }

    public MagicEyeNodeView firstChild() {
        MagicEyeNodeView fc = this.childs.get(0);
        if (fc.visible) {
            return fc;
        }
        return fc.rightSibling();
    }

    public MagicEyeNodeView lastChild() {
        MagicEyeNodeView lc = this.childs.get(this.numChilds - 1);
        if (lc.visible) {
            return lc;
        }
        return lc.leftSibling();
    }

    public void pathToRoot() {
        MagicEyeNodeView ni = null;
        MagicEyeNodeView n = this;
        MagicEyeNodeView p = n.parent;
        n.atPathToRoot = true;
        while (p != null) {
            if (p.parent != null) {
                for (int i = 0; i < p.numChilds; ++i) {
                    ni = p.getChild(i);
                    if (ni.atPathToRoot) continue;
                    ni.visible = false;
                }
                n.visible = true;
                p.visible = true;
                p.atPathToRoot = true;
            }
            n = p;
            p = p.parent;
        }
    }

    public boolean isPartiallyFolded() {
        int visibleChilds = 0;
        for (int i = 0; i < this.numChilds; ++i) {
            if (!this.getChild((int)i).visible) continue;
            ++visibleChilds;
        }
        return 0 < visibleChilds && visibleChilds < this.numChilds;
    }

    public void fold(boolean f) {
        this.folded = f;
    }

    public void unfoldOneLevel() {
        this.folded = false;
        for (int i = 0; i < this.numChilds; ++i) {
            MagicEyeNodeView ni = this.getChild(i);
            ni.atPathToRoot = false;
            ni.visible = true;
        }
    }

    public void unfoldComplete() {
        this.folded = false;
        for (int i = 0; i < this.numChilds; ++i) {
            MagicEyeNodeView ni = this.getChild(i);
            ni.atPathToRoot = false;
            ni.visible = true;
            ni.unfoldComplete();
        }
    }

    public void mark(boolean f) {
        this.markSubtree(f);
        this.markRootPath(f);
    }

    public void markSubtree(boolean f) {
        this.marked = f;
        for (int i = 0; i < this.numChilds; ++i) {
            this.getChild(i).markSubtree(f);
        }
    }

    public void markRootPath(boolean f) {
        MagicEyeNodeView n = this;
        while (n.parent != null) {
            n = n.parent;
            n.marked = f;
        }
    }
}

