/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms.magiceye;

import java.awt.Color;
import java.util.HashMap;
import java.util.Vector;
import javax.vecmath.Color3f;
import pedviz.algorithms.magiceye.MagicEyeLayout;
import pedviz.algorithms.magiceye.MagicEyeNodeView;
import pedviz.graph.Edge;
import pedviz.graph.LayoutedGraph;
import pedviz.graph.Node;

public class MagicEyeTree {
    LayoutedGraph graph;
    public HashMap<String, MagicEyeNodeView> nodes;
    Vector<MagicEyeNodeView> nodesToPrint;
    Vector<MagicEyeNodeView> focusNodes;
    Vector<MagicEyeNodeView> nodesWithManyParents;
    public MagicEyeNodeView root;
    int maxSN;
    float edgeWidthFactor;
    float edgeColorFactor;

    public MagicEyeTree(LayoutedGraph graph, Node c) {
        this.graph = graph;
        this.nodes = new HashMap();
        this.nodesToPrint = new Vector();
        this.focusNodes = new Vector();
        this.nodesWithManyParents = new Vector();
        this.root = this.buildMagicEyeNodeViewTree(c, null, 0, 0);
        this.generateCrossedgeTargets(this.root);
        this.addOtherParents(this.root);
        this.generateStrahlerNumbers(this.root);
        this.maxSN = this.root.strahlerNumber;
        this.edgeWidthFactor = 4.7f / (float)this.maxSN;
        this.edgeColorFactor = 0.9f / (float)Math.pow(this.maxSN, 0.167);
        this.calculateEdgeWidthsAndColors(this.root);
    }

    private MagicEyeNodeView buildMagicEyeNodeViewTree(Node c, MagicEyeNodeView parent, int level, int num) {
        String id = c.getId().toString();
        if (!this.nodes.containsKey(id)) {
            int maxi;
            MagicEyeNodeView n = (MagicEyeNodeView)this.graph.getNodeView(c);
            n.init(parent, level, num);
            this.nodes.put(id, n);
            this.focusNodes.add(n);
            n.numChilds = maxi = c.getOutDegree();
            int maxDepth = -1;
            n.leaves = 0;
            n.nodes = n.numChilds;
            MagicEyeNodeView ls = null;
            int i = 0;
            for (Edge e : c.getOutEdges()) {
                Node ci = e.getEnd();
                MagicEyeNodeView ni = this.buildMagicEyeNodeViewTree(ci, n, level + 1, i);
                if (ni != null) {
                    ni.leftSibling = ls;
                    if (ls != null) {
                        ls.rightSibling = ni;
                    }
                    ls = ni;
                    n.childs.addElement(ni);
                    n.leaves = ni.numChilds > 0 ? (n.leaves += ni.leaves) : ++n.leaves;
                    n.nodes += ni.nodes;
                    if (ni.depth > maxDepth) {
                        maxDepth = ni.depth;
                    }
                } else {
                    --n.numChilds;
                }
                ++i;
            }
            if (ls != null) {
                ls.rightSibling = null;
            }
            n.depth = maxDepth + 1;
            return n;
        }
        return null;
    }

    public MagicEyeNodeView getNode(String name) {
        return this.nodes.get(name);
    }

    public void removeAllFocusNodes() {
        this.clearFocusedFlags(this.root);
        this.clearAtPathToRootFlags(this.root);
        this.focusNodes.clear();
    }

    public void addFocusNode(String name) {
        MagicEyeNodeView n = this.getNode(name);
        if (n != null && !this.focusNodes.contains(n)) {
            this.focusNodes.add(n);
        }
    }

    void generateCrossedgeTargets(MagicEyeNodeView n) {
        Object targetname = null;
        String attrname = null;
        for (Edge e : n.getNode().getOutEdges()) {
            attrname = e.getEnd().getId().toString();
            n.crossedgeTargets.add(this.getNode(attrname));
            n.crossedgeStrings.add(attrname);
        }
        MagicEyeNodeView p = n.parent;
        if (p != null) {
            for (int i = 0; i < n.crossedgeTargets.size(); ++i) {
                MagicEyeNodeView target = n.crossedgeTargets.get(i);
                if (p.crossedgeTargets.contains(target)) continue;
                n.crossedgeTargetsNew.add(target);
                n.crossedgeStringsNew.add(n.crossedgeStrings.get(i));
            }
        }
        for (int i = 0; i < n.numChilds; ++i) {
            this.generateCrossedgeTargets(n.getChild(i));
        }
    }

    void addOtherParents(MagicEyeNodeView n) {
        for (Edge e : n.getNode().getInEdges()) {
            MagicEyeNodeView ni = this.getNode(e.getStart().getId().toString());
            if (ni == n.parent) continue;
            n.otherParents.add(ni);
        }
        if (n.otherParents.size() > 0) {
            this.nodesWithManyParents.add(n);
        }
        for (int i = 0; i < n.numChilds; ++i) {
            this.addOtherParents(n.getChild(i));
        }
    }

    void generateStrahlerNumbers(MagicEyeNodeView n) {
        int maxSN = 0;
        MagicEyeNodeView ni = null;
        boolean equal = true;
        if (n.numChilds == 0) {
            n.strahlerNumber = 0;
            return;
        }
        for (int i = 0; i < n.numChilds; ++i) {
            ni = n.getChild(i);
            this.generateStrahlerNumbers(ni);
            int sn = ni.strahlerNumber;
            if (sn != maxSN && i > 0) {
                equal = false;
            }
            if (sn <= maxSN) continue;
            maxSN = sn;
        }
        n.strahlerNumber = equal ? ni.strahlerNumber + n.numChilds - 1 : maxSN + n.numChilds - 2;
    }

    void calculateEdgeWidthsAndColors(MagicEyeNodeView n) {
        n.edgeWidth = (float)n.strahlerNumber * this.edgeWidthFactor + 1.3f;
        n.edgeColor = new Color3f();
        float sat = (float)Math.pow(n.strahlerNumber, 0.167) * this.edgeColorFactor + 0.1f;
        int c = Color.HSBtoRGB(0.7f, sat, 0.75f);
        n.edgeColor.set((float)((c & 0xFF0000) >> 16) / 255.0f, (float)((c & 0xFF00) >> 8) / 255.0f, (float)(c & 0xFF) / 255.0f);
        n.markedEdgeColor = new Color3f();
        c = Color.HSBtoRGB(0.35f, sat, 0.6f);
        n.markedEdgeColor.set((float)((c & 0xFF0000) >> 16) / 255.0f, (float)((c & 0xFF00) >> 8) / 255.0f, (float)(c & 0xFF) / 255.0f);
        for (int i = 0; i < n.numChilds; ++i) {
            this.calculateEdgeWidthsAndColors(n.getChild(i));
        }
    }

    public void clearFocusedFlags(MagicEyeNodeView n) {
        if (n.focused) {
            n.focused = false;
            for (int i = 0; i < n.numChilds; ++i) {
                this.clearFocusedFlags(n.getChild(i));
            }
        }
    }

    public void clearAtPathToRootFlags(MagicEyeNodeView n) {
        for (int i = 0; i < n.numChilds; ++i) {
            MagicEyeNodeView ni = n.getChild(i);
            if (!ni.atPathToRoot) continue;
            ni.atPathToRoot = false;
            this.clearAtPathToRootFlags(ni);
        }
    }

    public void buildFocusSet() {
        int i;
        this.automaticFold();
        for (i = 0; i < this.focusNodes.size(); ++i) {
            MagicEyeNodeView n = this.focusNodes.get(i);
            n.focused = true;
            MagicEyeNodeView p = n.parent;
            while (p != null) {
                p.focused = true;
                p = p.parent;
            }
            if (n.numChilds <= 0) continue;
            n.getChild((int)0).focused = true;
        }
        this.foldNoFocusNodes(this.root);
        for (i = 0; i < this.focusNodes.size(); ++i) {
            this.focusNodes.get(i).pathToRoot();
        }
    }

    void foldNoFocusNodes(MagicEyeNodeView n) {
        boolean foldn = true;
        for (int i = 0; i < n.numChilds; ++i) {
            MagicEyeNodeView ni = n.getChild(i);
            if (ni.focused) {
                foldn = false;
                ni.fold(false);
                this.foldNoFocusNodes(ni);
                continue;
            }
            if (ni.numChilds <= 0) continue;
            ni.fold(true);
        }
        if (n.numChilds > 0 && foldn) {
            n.fold(true);
        }
    }

    public void FFEV(MagicEyeNodeView n) {
        this.nodesToPrint.clear();
        this.downFFEV(n, n.level);
        this.upFFEV(n, n.level);
    }

    void downFFEV(MagicEyeNodeView n, int doi) {
        if (MagicEyeLayout.FFEV_THRESHOLD > doi) {
            this.nodesToPrint.add(n);
            if (!n.folded) {
                for (int i = 0; i < n.numChilds; ++i) {
                    this.downFFEV(n.getChild(i), doi + 2);
                }
            }
        }
    }

    void upFFEV(MagicEyeNodeView n, int doi) {
        if (doi < MagicEyeLayout.FFEV_THRESHOLD) {
            this.nodesToPrint.add(n);
            if (n.parent != null) {
                MagicEyeNodeView p = n.parent;
                if (doi + 2 < MagicEyeLayout.FFEV_THRESHOLD) {
                    for (int i = 0; i < p.numChilds; ++i) {
                        MagicEyeNodeView ni = p.getChild(i);
                        if (ni == n) continue;
                        this.downFFEV(ni, doi + 2);
                    }
                }
                this.upFFEV(p, doi);
            }
        }
    }

    public void automaticFold() {
        this.boxANode(this.root);
    }

    FoldData boxANode(MagicEyeNodeView n) {
        FoldData retval = new FoldData();
        if (n.numChilds == 0) {
            retval.n = 1;
            retval.k = 1;
        } else {
            retval.n = 1;
            retval.k = 0;
            for (int i = 0; i < n.numChilds; ++i) {
                FoldData childData = this.boxANode(n.getChild(i));
                retval.n += childData.n;
                retval.k += childData.k;
            }
            if (n.parent != null && retval.n > MagicEyeLayout.FOLDING_THRESHOLD && !this.isNormal(retval)) {
                n.fold(true);
                retval.n = 1;
                retval.k = 1;
            }
        }
        return retval;
    }

    boolean isNormal(FoldData fd) {
        double n = fd.n;
        double k = fd.k;
        double a = 1.96 * Math.sqrt(n / 8.0);
        double alpha = Math.floor(n / 2.0 - a);
        double beta = Math.ceil(n / 2.0 + a);
        return alpha <= k && k <= beta;
    }

    private static class FoldData {
        int n;
        int k;

        private FoldData() {
        }
    }
}

