/*
 * Decompiled with CFR 0.152.
 */
package pedviz.graph;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import pedviz.event.NodeViewEvent;
import pedviz.event.NodeViewListener;
import pedviz.graph.Edge;
import pedviz.graph.Graph;
import pedviz.graph.Hierarchy;
import pedviz.graph.Layout;
import pedviz.graph.Node;
import pedviz.view.DefaultEdgeView;
import pedviz.view.DefaultNodeView;
import pedviz.view.EdgeView;
import pedviz.view.NodeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutedGraph<N extends NodeView, E extends EdgeView>
implements NodeViewListener {
    Graph graph;
    HashMap<Object, N> nodes;
    HashMap<Object, N> subNodes;
    ArrayList<E> edges;
    DefaultNodeView defaultNodeView;
    DefaultEdgeView defaultEdgeView;
    Layout layout;
    HashMap<Integer, Float> posHierarchie;
    float border = 14.0f;
    Rectangle2D.Float bounds;

    public LayoutedGraph(Graph graph, Layout layout, DefaultNodeView defaultNodeView, DefaultEdgeView defaultEdgeView) {
        this.graph = graph;
        this.defaultNodeView = defaultNodeView;
        this.defaultEdgeView = defaultEdgeView;
        this.layout = layout;
        this.bounds = new Rectangle2D.Float();
        this.posHierarchie = new HashMap();
        this.updateModel();
    }

    public ArrayList<E> getEdges() {
        return this.edges;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Collection<N> getNodes() {
        return this.nodes.values();
    }

    public Collection<N> getSubNodes() {
        return this.subNodes.values();
    }

    public HashMap<Object, N> getAllNodes() {
        HashMap<Object, N> result = new HashMap<Object, N>();
        result.putAll(this.nodes);
        result.putAll(this.subNodes);
        return result;
    }

    public N getNodeView(Object id) {
        NodeView result = (NodeView)this.nodes.get(id);
        if (result == null) {
            return (N)((NodeView)this.subNodes.get(id));
        }
        return (N)result;
    }

    public N getNodeView(Node node) {
        return this.getNodeView(node.getId());
    }

    public DefaultEdgeView getDefaultEdgeView() {
        return this.defaultEdgeView;
    }

    public void setDefaultEdgeView(DefaultEdgeView defaultEdgeView) {
        this.defaultEdgeView = defaultEdgeView;
    }

    public DefaultNodeView getDefaultNodeView() {
        return this.defaultNodeView;
    }

    public void setDefaultNodeView(DefaultNodeView defaultNodeView) {
        this.defaultNodeView = defaultNodeView;
    }

    public void updateModel() {
        this.edges = new ArrayList();
        this.nodes = new HashMap();
        this.subNodes = new HashMap();
        for (int i = 0; i < this.graph.getHierachiesCount(); ++i) {
            Hierarchy hierarchie = this.graph.getHierachy(i);
            for (Integer j : hierarchie.getNodes().keySet()) {
                if (hierarchie.getNodes(j) == null) continue;
                for (Node node : hierarchie.getNodes(j)) {
                    Object nodeview = this.layout.createNodeView(node, this.defaultNodeView);
                    ((NodeView)nodeview).addNodeViewListener(this);
                    ((DefaultNodeView)nodeview).setSymbols((ArrayList)this.defaultNodeView.getSymbols().clone());
                    this.nodes.put(node.getId(), nodeview);
                    for (Node subnode : node.getNodes()) {
                        Object nodeview2 = this.layout.createNodeView(subnode, this.defaultNodeView);
                        ((NodeView)nodeview2).addNodeViewListener(this);
                        ((DefaultNodeView)nodeview2).setSymbols((ArrayList)this.defaultNodeView.getSymbols().clone());
                        this.subNodes.put(subnode.getId(), nodeview2);
                        ((NodeView)nodeview).getNodes().add((NodeView)nodeview2);
                    }
                }
            }
        }
        ArrayList<Node> t = new ArrayList<Node>();
        for (Edge edge : this.graph.getEdges()) {
            Object edgeview = this.layout.createEdgeView(edge, this.defaultEdgeView);
            ArrayList<NodeView> end = new ArrayList<NodeView>();
            if (t.contains(edge.getEnd())) {
                ((DefaultEdgeView)edgeview).setConnectChildren(false);
            } else {
                t.add(edge.getEnd());
            }
            if (edge.getEnd().getNodes().size() > 0) {
                for (Node node : edge.getEnd().getNodes()) {
                    end.add((NodeView)this.getNodeView(node.getId()));
                    ((NodeView)this.getNodeView(node.getId())).getInEdges().add((EdgeView)edgeview);
                }
            } else {
                end.add((NodeView)this.getNodeView(edge.getEnd().getId()));
                ((NodeView)this.getNodeView(edge.getEnd().getId())).getInEdges().add((EdgeView)edgeview);
            }
            NodeView start = null;
            if (edge.getStart().getNodes().size() > 0) {
                for (Node node : edge.getStart().getNodes()) {
                    if (!node.getId().equals(((NodeView)end.get(0)).getNode().getIdDad()) && !node.getId().equals(((NodeView)end.get(0)).getNode().getIdMom())) continue;
                    start = (NodeView)this.getNodeView(node.getId());
                    ((NodeView)this.getNodeView(node.getId())).getOutEdges().add((EdgeView)edgeview);
                }
            } else {
                start = (NodeView)this.getNodeView(edge.getStart().getId());
                ((NodeView)this.getNodeView(edge.getStart().getId())).getOutEdges().add((EdgeView)edgeview);
            }
            ((EdgeView)edgeview).setStart(start);
            ((EdgeView)edgeview).setEnds(end);
            this.edges.add(edgeview);
        }
        t.clear();
    }

    @Override
    public void nodeChanged(NodeViewEvent event) {
        if (event.getType() == 1) {
            if (this.bounds.x > event.getNodeview().getPosX() - this.border) {
                float oldX = this.bounds.x;
                this.bounds.x = event.getNodeview().getPosX() - this.border;
                this.bounds.width += Math.abs(this.bounds.x - oldX);
            }
            if (this.bounds.width + this.bounds.x < event.getNodeview().getPosX() + this.border) {
                this.bounds.width = event.getNodeview().getPosX() - this.bounds.x + this.border;
            }
        }
        if (event.getType() == 2) {
            if (this.bounds.y > event.getNodeview().getPosY() - this.border) {
                float oldY = this.bounds.y;
                this.bounds.y = event.getNodeview().getPosY() - this.border;
                this.bounds.height += Math.abs(this.bounds.y - oldY);
            }
            if (this.bounds.y + this.bounds.height < event.getNodeview().getPosY() + event.getNodeview().getHeight().floatValue() + this.border) {
                this.bounds.height = event.getNodeview().getPosY() + event.getNodeview().getHeight().floatValue() - this.bounds.y + this.border;
            }
        }
        if (event.getType() == 3) {
            // empty if block
        }
    }

    public Rectangle2D.Float getBounds() {
        return this.bounds;
    }

    public void setBounds(float x, float y, float width, float height) {
        this.bounds.x = x;
        this.bounds.y = y;
        this.bounds.width = width;
        this.bounds.height = height;
    }

    public Float getPosHierarchie(int i) {
        return this.posHierarchie.get(i);
    }

    public void setPosHierarchie(int i, float pos) {
        this.posHierarchie.put(i, Float.valueOf(pos));
    }
}

