/*
 * Decompiled with CFR 0.152.
 */
package pedviz.haplotype;

import java.awt.Color;
import java.util.HashMap;
import java.util.Vector;
import pedviz.haplotype.HaplotypeItem;
import pedviz.haplotype.MerlinError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Haplotypes {
    protected HashMap<Object, Color> founderColors = new HashMap();
    protected HashMap<Object, Vector<HaplotypeItem>> datas = new HashMap();
    protected HashMap<Object, Boolean> founders;
    protected Vector<String> markers = new Vector();
    protected Vector<String> pos = new Vector();
    protected Vector<String> chr = new Vector();
    protected Vector<Integer> visibles;
    protected HashMap<Object, MerlinError> errors;
    private boolean hideAll = false;

    public Haplotypes() {
        this.founders = new HashMap();
        this.visibles = new Vector();
        this.errors = new HashMap();
    }

    public Vector<HaplotypeItem> getData(Object id) {
        return this.datas.get(id);
    }

    public Vector<String> getMarkers() {
        return this.markers;
    }

    public boolean isMarkerVisible(int marker) {
        if (this.visibles.isEmpty() && !this.hideAll) {
            return true;
        }
        if (this.hideAll) {
            return false;
        }
        return this.visibles.contains(marker);
    }

    public int getVisibleSize() {
        if (this.visibles.isEmpty()) {
            return this.markers.size();
        }
        if (this.hideAll) {
            return 0;
        }
        return this.visibles.size();
    }

    public void hideAllMarkers() {
        this.hideAll = true;
        this.visibles.clear();
    }

    public void showAllMarkers() {
        this.hideAll = false;
        this.visibles.clear();
    }

    public void showMarker(int marker) {
        this.hideAll = false;
        this.visibles.add(marker);
    }

    public int getSize() {
        return this.markers.size();
    }

    public Vector<String> getPos() {
        return this.pos;
    }

    public HashMap<Object, MerlinError> getErrors() {
        return this.errors;
    }

    protected void findPatterns() {
        for (Object id : this.datas.keySet()) {
            Color color;
            int j;
            if (this.founders.get(id).booleanValue()) continue;
            int lastIndex = 0;
            int lastIndexB = 0;
            boolean useDad = false;
            boolean useMom = false;
            boolean found = false;
            boolean useDadB = false;
            boolean useMomB = false;
            boolean foundB = false;
            for (int i = 0; i < this.datas.get(id).size(); ++i) {
                Color color2;
                HaplotypeItem item = this.datas.get(id).get(i);
                HaplotypeItem dad = this.datas.get(item.getDadId()).get(i);
                if (!found) {
                    if (!dad.getDad().equals(dad.getMom())) {
                        if (item.getDad().equals(dad.getDad())) {
                            useDad = true;
                            found = true;
                            useMom = false;
                        }
                        if (item.getDad().equals(dad.getMom())) {
                            useMom = true;
                            found = true;
                            useDad = false;
                        }
                    }
                } else if (useDad) {
                    if (!item.getDad().equals(dad.getDad())) {
                        for (int j2 = lastIndex; j2 < i; ++j2) {
                            Color color3 = this.datas.get(item.getDadId()).get(j2).getColorDad();
                            this.datas.get(id).get(j2).setColorDad(color3);
                        }
                        useDad = false;
                        useMom = !dad.getDad().equals(dad.getMom());
                        found = false;
                        lastIndex = i;
                    }
                } else if (!item.getDad().equals(dad.getMom())) {
                    for (int j3 = lastIndex; j3 < i; ++j3) {
                        Color color4 = this.datas.get(item.getDadId()).get(j3).getColorMom();
                        this.datas.get(id).get(j3).setColorDad(color4);
                    }
                    useDad = !dad.getDad().equals(dad.getMom());
                    useMom = false;
                    found = false;
                    lastIndex = i;
                }
                HaplotypeItem mom = this.datas.get(item.getMomId()).get(i);
                if (!foundB) {
                    if (mom.getDad().equals(mom.getMom())) continue;
                    if (item.getMom().equals(mom.getDad())) {
                        useDadB = true;
                        foundB = true;
                        useMomB = false;
                    }
                    if (!item.getMom().equals(mom.getMom())) continue;
                    useMomB = true;
                    foundB = true;
                    useDadB = false;
                    continue;
                }
                if (useDadB) {
                    if (item.getMom().equals(mom.getDad())) continue;
                    for (int j4 = lastIndexB; j4 < i; ++j4) {
                        color2 = this.datas.get(item.getMomId()).get(j4).getColorDad();
                        this.datas.get(id).get(j4).setColorMom(color2);
                    }
                    useDadB = false;
                    useMomB = !mom.getDad().equals(mom.getMom());
                    foundB = false;
                    lastIndexB = i;
                    continue;
                }
                if (item.getMom().equals(mom.getMom())) continue;
                for (int j5 = lastIndexB; j5 < i; ++j5) {
                    color2 = this.datas.get(item.getMomId()).get(j5).getColorMom();
                    this.datas.get(id).get(j5).setColorMom(color2);
                }
                useDadB = !mom.getDad().equals(mom.getMom());
                useMomB = false;
                foundB = false;
                lastIndexB = i;
            }
            if (useDad) {
                for (j = lastIndex; j < this.datas.get(id).size(); ++j) {
                    color = this.datas.get(this.datas.get(id).get(j).getDadId()).get(j).getColorDad();
                    this.datas.get(id).get(j).setColorDad(color);
                }
            }
            if (useMom) {
                for (j = lastIndex; j < this.datas.get(id).size(); ++j) {
                    color = this.datas.get(this.datas.get(id).get(j).getDadId()).get(j).getColorMom();
                    this.datas.get(id).get(j).setColorDad(color);
                }
            }
            if (useDadB) {
                for (j = lastIndexB; j < this.datas.get(id).size(); ++j) {
                    color = this.datas.get(this.datas.get(id).get(j).getMomId()).get(j).getColorDad();
                    this.datas.get(id).get(j).setColorMom(color);
                }
            }
            if (!useMomB) continue;
            for (j = lastIndexB; j < this.datas.get(id).size(); ++j) {
                color = this.datas.get(this.datas.get(id).get(j).getMomId()).get(j).getColorMom();
                this.datas.get(id).get(j).setColorMom(color);
            }
        }
    }
}

