/*
 * Decompiled with CFR 0.152.
 */
package pedviz.haplotype;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;
import pedviz.haplotype.HaplotypeItem;
import pedviz.haplotype.Haplotypes;
import pedviz.haplotype.MerlinError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MerlinHaplotypes
extends Haplotypes {
    public MerlinHaplotypes(String filename, String map) {
        this(filename, map, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MerlinHaplotypes(String filename, String map, boolean resource) {
        String line;
        File f;
        BufferedReader reader = null;
        FileInputStream fis = null;
        Vector ids = new Vector();
        Vector<String> idsMom = new Vector<String>();
        Vector<String> idsDad = new Vector<String>();
        int mark = 0;
        try {
            if (resource) {
                reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename)));
            } else {
                f = new File(filename);
                fis = new FileInputStream(f);
                reader = new BufferedReader(new InputStreamReader(fis));
            }
            line = null;
            while ((line = reader.readLine()) != null) {
                Vector<HaplotypeItem> data;
                Object id;
                int i;
                int columns;
                if (line.equals("") || !line.startsWith(" ")) continue;
                String[] tiles = line.trim().split("\\s+");
                if (tiles[1].startsWith("(")) {
                    columns = tiles.length / 2;
                    ids.clear();
                    idsMom.clear();
                    idsDad.clear();
                    for (i = 0; i < columns; ++i) {
                        id = tiles[i * 2];
                        if (tiles[i * 2 + 1].equals("(F)")) {
                            this.founders.put(id, true);
                            this.founderColors.put(id + "A", new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0)));
                            this.founderColors.put(id + "B", new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0)));
                            idsDad.add("");
                            idsMom.add("");
                        } else {
                            this.founders.put(id, false);
                            String[] temp = tiles[i * 2 + 1].split(",");
                            idsMom.add(temp[0].replace("(", ""));
                            idsDad.add(temp[1].replace(")", ""));
                        }
                        ids.add(id);
                        data = new Vector<HaplotypeItem>();
                        this.datas.put(id, data);
                    }
                    mark = 0;
                    continue;
                }
                columns = tiles.length / 3;
                for (i = 0; i < columns; ++i) {
                    id = ids.get(i);
                    data = (Vector<HaplotypeItem>)this.datas.get(id);
                    Color color1 = Color.RED;
                    Color color2 = Color.RED;
                    if (((Boolean)this.founders.get(id)).booleanValue()) {
                        color1 = (Color)this.founderColors.get(id + "A");
                        color2 = (Color)this.founderColors.get(id + "B");
                    }
                    String mom = tiles[i * 3].split(",")[0];
                    String dad = tiles[i * 3 + 2];
                    if (dad.split(",").length > 1) {
                        dad = dad.split(",")[0].substring(1);
                    }
                    HaplotypeItem temp = new HaplotypeItem(mom, dad, color1, color2);
                    temp.setDadId((String)idsDad.get(i));
                    temp.setMomId((String)idsMom.get(i));
                    data.add(temp);
                }
                if (!this.markers.contains("Marker_" + (mark + 1))) {
                    this.markers.add("Marker_" + (mark + 1));
                }
                ++mark;
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                }
            }
        }
        if (map != null) {
            try {
                if (resource) {
                    reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(map)));
                } else {
                    f = new File(map);
                    fis = new FileInputStream(f);
                    reader = new BufferedReader(new InputStreamReader(fis));
                }
                line = null;
                int i = 0;
                while ((line = reader.readLine()) != null) {
                    if (line.equals("") || line.startsWith("#")) continue;
                    String[] tiles = line.trim().split("\\s+");
                    this.chr.add(tiles[0]);
                    this.pos.add(tiles[2]);
                    this.markers.set(i, tiles[1]);
                    ++i;
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        System.out.println(ioe.getMessage());
                    }
                }
            }
        }
        this.findPatterns();
    }

    public void setErrors(HashMap<Object, MerlinError> errors) {
        this.errors = errors;
    }
}

