/*
 * Decompiled with CFR 0.152.
 */
package pedviz.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import pedviz.graph.Edge;
import pedviz.graph.Graph;
import pedviz.graph.Node;
import pedviz.loader.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PedGraphLoader
extends Loader {
    private String filename;
    private ArrayList<String> attributes;
    private HashMap<String, Integer> types;
    public static final int INTEGER = 0;
    public static final int DOUBLE = 1;

    public PedGraphLoader(String filename) {
        this.filename = filename;
        this.attributes = new ArrayList();
        this.types = new HashMap();
    }

    public void setColumnType(String column, int type) {
        this.types.put(column, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Graph graph) {
        int colFam = -1;
        int colAff = -1;
        int colId = -1;
        int colIdMom = -1;
        int colIdDad = -1;
        int colSex = -1;
        BufferedReader reader = null;
        FileInputStream fis = null;
        ArrayList<Object[]> myEdges = new ArrayList<Object[]>();
        try {
            File f = new File(this.filename);
            graph.setName(f.getName());
            fis = new FileInputStream(f);
            reader = new BufferedReader(new InputStreamReader(fis));
            String row = null;
            colFam = 0;
            colId = 1;
            colIdMom = 2;
            colIdDad = 3;
            colSex = 4;
            colAff = 5;
            while ((row = reader.readLine()) != null) {
                String[] columns = row.trim().split("\\s+");
                if (columns.length < 5) continue;
                String id = null;
                String idMom = null;
                String idDad = null;
                id = columns[colId];
                if (!columns[colIdMom].equals("")) {
                    idMom = columns[colIdMom];
                }
                if (!columns[colIdDad].equals("")) {
                    idDad = columns[colIdDad];
                }
                Node node = new Node(id);
                node.setUserData("pid", id);
                node.setIdDad(idDad);
                node.setUserData("dad", idDad);
                node.setIdMom(idMom);
                node.setUserData("mom", idMom);
                node.setUserData("fam", columns[colFam]);
                node.setUserData("aff", columns[colAff]);
                myEdges.add(new Object[]{idDad, id});
                myEdges.add(new Object[]{idMom, id});
                graph.addNode(node);
                if (columns[colSex].equals("")) continue;
                node.setUserData("sex", columns[colSex]);
            }
            for (Object[] edge : myEdges) {
                Node start = graph.getNode(edge[0]);
                Node end = graph.getNode(edge[1]);
                if (start == null || end == null) continue;
                Edge edge2 = new Edge(start, end);
                graph.addEdge(edge2);
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                }
            }
        }
    }

    @Override
    public Vector<String> getColumns() {
        Vector<String> colStrings = new Vector<String>();
        colStrings.add("Pid");
        colStrings.add("Mom");
        colStrings.add("Dad");
        colStrings.add("Sex");
        colStrings.add("Aff");
        colStrings.add("Fam");
        Collections.sort(colStrings);
        return colStrings;
    }
}

