/*
 * Decompiled with CFR 0.152.
 */
package pedviz.rpedviz;

import java.awt.Color;
import pedviz.algorithms.Sugiyama;
import pedviz.graph.Graph;
import pedviz.loader.ArrayGraphLoader;
import pedviz.rpedviz.RPedviz;
import pedviz.view.DefaultEdgeView;
import pedviz.view.DefaultNodeView;
import pedviz.view.GraphView2D;
import pedviz.view.LODHighlighter;
import pedviz.view.rules.Rule;
import pedviz.view.rules.ShapeRule;
import pedviz.view.symbols.SymbolAdopted;
import pedviz.view.symbols.SymbolDeceased;
import pedviz.view.symbols.SymbolQualitativeTrait;
import pedviz.view.symbols.SymbolSexFemale;
import pedviz.view.symbols.SymbolSexMale;
import pedviz.view.symbols.SymbolSexUndesignated;

public class RPedviz2D
extends RPedviz {
    public RPedviz2D() {
        super("RPedviz 2d");
    }

    public void plot(String format, String seperator, String[] args, String[] hints, boolean highlighter) {
        this.graph = new Graph();
        ArrayGraphLoader loader = new ArrayGraphLoader(format, seperator, args);
        loader.setSettings("PID", "MOM", "DAD");
        loader.load(this.graph);
        DefaultEdgeView e = new DefaultEdgeView();
        e.setColor(new Color(50, 50, 50));
        e.setColorForLongLines(new Color(200, 200, 200));
        e.setGapBottom(5);
        e.setHighlightedColor(Color.red);
        e.setConnectChildren(true);
        DefaultNodeView d = new DefaultNodeView();
        d.setColor(new Color(255, 255, 255));
        d.setBorderColor(new Color(0, 0, 0));
        if (hints != null) {
            for (String attr : hints) {
                d.addHintAttribute(attr);
            }
        }
        Sugiyama sugiyama = new Sugiyama(this.graph, d, e);
        sugiyama.run();
        this.graphView = new GraphView2D(sugiyama.getLayoutedGraph());
        this.graphView.setBackgroundColor(new Color(255, 255, 255));
        this.graphView.addRule(new ShapeRule("sex", "-1", new SymbolSexUndesignated()));
        this.graphView.addRule(new ShapeRule("sex", "1", new SymbolSexMale()));
        this.graphView.addRule(new ShapeRule("sex", "2", new SymbolSexFemale()));
        this.graphView.addRule(new ShapeRule("dead", "1", new SymbolDeceased()));
        this.graphView.addRule(new ShapeRule("adopted", "1", new SymbolAdopted()));
        for (Rule rule : this.rules) {
            this.graphView.addRule(rule);
        }
        this.graphView.setSelectionEnabled(true);
        this.lodHighlighter = new LODHighlighter(this.mode);
        this.graphView.addNodeListener(this.lodHighlighter);
        this.getContentPane().add(this.graphView.getComponent(), "Center");
        this.toolBar.setVisible(highlighter);
        this.setVisible(true);
    }

    public void addSymbolRule(String trait, String value, String symbol) {
        if (symbol.toLowerCase().equals("male")) {
            this.rules.add(new ShapeRule(trait, value, new SymbolSexMale()));
        }
        if (symbol.toLowerCase().equals("female")) {
            this.rules.add(new ShapeRule(trait, value, new SymbolSexFemale()));
        }
        if (symbol.toLowerCase().equals("undesignated")) {
            this.rules.add(new ShapeRule(trait, value, new SymbolSexUndesignated()));
        }
        if (symbol.toLowerCase().equals("deceased")) {
            this.rules.add(new ShapeRule(trait, value, new SymbolDeceased()));
        }
        if (symbol.toLowerCase().equals("adopted")) {
            this.rules.add(new ShapeRule(trait, value, new SymbolAdopted()));
        }
    }

    public void addQualitativeTrait(String trait, double min, double max, double mean, double scope) {
        this.rules.add(new ShapeRule(new SymbolQualitativeTrait(trait, min, max, mean, scope)));
    }
}

