/*
 * Decompiled with CFR 0.152.
 */
package pedviz.view;

import java.awt.Color;
import java.util.List;
import pedviz.graph.Edge;
import pedviz.view.DefaultEdgeView;
import pedviz.view.NodeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeView
extends DefaultEdgeView {
    private NodeView start;
    private List<NodeView> end;
    private Edge edge;
    private Object data;

    public EdgeView(Edge edge, DefaultEdgeView defaultEdgeView) {
        this.edge = edge;
        this.setColor(defaultEdgeView.getColor());
        this.setWidth(defaultEdgeView.getWidth());
        this.setHighlightedColor(defaultEdgeView.getHighlightedColor());
        this.setGapBottom(defaultEdgeView.getGapBottom());
        this.setGapTop(defaultEdgeView.getGapTop());
        this.setConnectChildren(defaultEdgeView.isConnectChildren());
        this.setColorForLongLines(defaultEdgeView.getColorForLongLines());
        this.setHighlightedWidth(defaultEdgeView.getHighlightedWidth());
        this.setColorForLongLines(defaultEdgeView.getColorForLongLines());
        this.setAlphaForLongLines(defaultEdgeView.getAlphaForLongLines());
        this.setAlpha(defaultEdgeView.getAlpha());
        this.setDeltaForLongLines(defaultEdgeView.getDeltaX(), defaultEdgeView.getDeltaY(), defaultEdgeView.getDeltaZ());
    }

    public boolean isHighlighted() {
        boolean s = this.start.isHighlighted() || this.start.isMouseOver();
        boolean e = false;
        for (NodeView endNode : this.end) {
            e = e || endNode.isHighlighted() || endNode.isMouseOver();
        }
        return s && e;
    }

    public boolean isHidden() {
        boolean s = this.start.isHidden();
        boolean e = false;
        for (NodeView endNode : this.end) {
            e = e || !endNode.isHidden();
        }
        return s || !e;
    }

    public Edge getEdge() {
        return this.edge;
    }

    public NodeView getEnd() {
        return this.end.get(0);
    }

    public NodeView getStart() {
        return this.start;
    }

    public List<NodeView> getEnds() {
        return this.end;
    }

    public void setStart(NodeView start) {
        this.start = start;
    }

    public void setEnds(List<NodeView> end) {
        this.end = end;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public Color getColor() {
        if (this.getColorForLongLines() != null && this.end != null) {
            if (this.start.getNode().isDummy() || this.end.get(0).getNode().isDummy()) {
                return this.getColorForLongLines();
            }
            if (Math.abs(this.start.getPosX() - this.end.get(0).getPosX()) > this.getDeltaX() || Math.abs(this.start.getPosY() - this.end.get(0).getPosY()) > this.getDeltaY() || Math.abs(this.start.getPosZ() - this.end.get(0).getPosZ()) > this.getDeltaZ()) {
                return this.getColorForLongLines();
            }
        }
        return super.getColor();
    }

    @Override
    public float getAlpha() {
        if (!this.isHighlighted()) {
            if (this.start.getNode().isDummy() || this.end.get(0).getNode().isDummy()) {
                return this.getAlphaForLongLines();
            }
            if (Math.abs(this.start.getPosX() - this.end.get(0).getPosX()) > this.getDeltaX() || Math.abs(this.start.getPosY() - this.end.get(0).getPosY()) > this.getDeltaY() || Math.abs(this.start.getPosZ() - this.end.get(0).getPosZ()) > this.getDeltaZ()) {
                return this.getAlphaForLongLines();
            }
        }
        return super.getAlpha();
    }
}

