/*
 * Decompiled with CFR 0.152.
 */
package pedviz.view;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Vector;
import pedviz.event.NodeViewEvent;
import pedviz.event.NodeViewListener;
import pedviz.graph.Node;
import pedviz.view.DefaultNodeView;
import pedviz.view.EdgeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeView
extends DefaultNodeView
implements Comparable {
    private Node node = null;
    private boolean selected = false;
    private boolean highlighted = false;
    private boolean mouseOver = false;
    private boolean hidden = false;
    private float posX;
    private float posY;
    private float posZ;
    private Object data;
    private Color[] colors;
    ArrayList<NodeView> nodes;
    ArrayList<EdgeView> outEdges;
    ArrayList<EdgeView> inEdges;
    Rectangle2D.Float bounds;
    Vector<NodeViewListener> listeners;
    private boolean momLeft = true;

    public NodeView(Node node, DefaultNodeView defaultNodeView) {
        this.node = node;
        this.posX = 0.0f;
        this.posY = 0.0f;
        this.posZ = 0.0f;
        this.listeners = new Vector();
        this.reset(defaultNodeView);
        this.setExpand(defaultNodeView.isExpand());
        this.nodes = new ArrayList();
        this.outEdges = new ArrayList();
        this.inEdges = new ArrayList();
    }

    public Object clone() {
        NodeView result = new NodeView(this.node, this);
        result.setColor(this.getColor());
        result.setSelectedColor(this.getSelectedColor());
        result.setHighlightedColor(this.getHighlightedColor());
        result.setSymbols((ArrayList)this.getSymbols().clone());
        result.setSize(this.getSize());
        result.setHintAttributes(this.getHintAttributes());
        result.setBorderColor(this.getBorderColor());
        result.setBorderWidth(this.getBorderWidth());
        result.setGap(this.getGap());
        result.setSelected(this.isSelected());
        result.setHighlighted(this.isHighlighted());
        result.setMouseOver(this.isMouseOver());
        return result;
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isSelected() {
        return this.selected;
    }

    protected void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    protected void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    protected void setMouseOver(boolean mouseOver) {
        this.mouseOver = mouseOver;
    }

    public String getHint() {
        if (this.getHintText() != null) {
            return this.getHintText();
        }
        String hint = "";
        if (this.getHintAttributes().size() > 0) {
            for (String hintAttribute : this.getHintAttributes()) {
                if (!hint.equals("")) {
                    hint = hint + "\n";
                }
                if (this.getNode().getUserData(hintAttribute) == null) continue;
                hint = hint + hintAttribute + ": " + this.getNode().getUserData(hintAttribute).toString();
            }
            return hint;
        }
        return null;
    }

    public float getPosX() {
        return this.posX;
    }

    public float getPosY() {
        return this.posY;
    }

    public float getPosZ() {
        return this.posZ;
    }

    public Rectangle2D.Float getBounds() {
        return this.bounds;
    }

    public void setBounds(double x, double y, double size) {
        this.bounds = new Rectangle2D.Float();
        this.bounds.setRect(x - size / 2.0, y - size / 2.0, size, size + (double)this.getHeight().floatValue());
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public ArrayList<NodeView> getNodes() {
        return this.nodes;
    }

    public ArrayList<EdgeView> getInEdges() {
        return this.inEdges;
    }

    public ArrayList<EdgeView> getOutEdges() {
        return this.outEdges;
    }

    public void setPosX(float x) {
        this.posX = x;
        this.fireNodeViewEvent(new NodeViewEvent(this, 1));
    }

    public void setPosY(float y) {
        this.posY = y;
        this.fireNodeViewEvent(new NodeViewEvent(this, 2));
    }

    public void setPosZ(float z) {
        this.posZ = z;
        this.fireNodeViewEvent(new NodeViewEvent(this, 3));
    }

    public void sortSubNodes() {
    }

    public int compareTo(Object arg0) {
        return 0;
    }

    public void reset(DefaultNodeView defaultNodeView) {
        this.setColor(defaultNodeView.getColor());
        this.setSelectedColor(defaultNodeView.getSelectedColor());
        this.setHighlightedColor(defaultNodeView.getHighlightedColor());
        this.setSymbols((ArrayList)defaultNodeView.getSymbols().clone());
        this.setSize(defaultNodeView.getSize());
        this.setHintAttributes(defaultNodeView.getHintAttributes());
        this.setBorderColor(defaultNodeView.getBorderColor());
        this.setBorderWidth(defaultNodeView.getBorderWidth());
        this.setGap(defaultNodeView.getGap());
    }

    public float calcWidth(int nodeSize, int gap) {
        if (this.isExpand()) {
            if (this.node.getNodeCount() == 0) {
                return nodeSize;
            }
            return this.node.getNodeCount() * nodeSize + (this.node.getNodeCount() - 1) * gap;
        }
        return nodeSize;
    }

    public void addNodeViewListener(NodeViewListener listener) {
        this.listeners.add(listener);
    }

    public void removeNodeViewListener(NodeViewListener listener) {
        this.listeners.remove(listener);
    }

    private void fireNodeViewEvent(NodeViewEvent event) {
        for (NodeViewListener listener : this.listeners) {
            listener.nodeChanged(event);
        }
    }

    public boolean isMomLeft() {
        return this.momLeft;
    }

    public void setMomLeft(boolean momLeft) {
        this.momLeft = momLeft;
    }
}

