/*
 * Decompiled with CFR 0.152.
 */
package pedviz.view;

import java.util.ArrayList;
import javax.swing.JOptionPane;
import pedviz.algorithms.Highlighter;
import pedviz.graph.Node;
import pedviz.view.NodeEvent;
import pedviz.view.NodeListener;

public class PathHighlighter
implements NodeListener {
    private boolean enabled = true;

    public void onNodeEvent(NodeEvent event) {
        if (this.enabled) {
            switch (event.getType()) {
                case 2: {
                    Node nodeB;
                    event.getGraphView().setMultiselection(true);
                    if (event.getGraphView().getSelectionCount() != 2) break;
                    Node nodeA = event.getGraphView().getSelection().get(0);
                    ArrayList<Node> nodes2 = Highlighter.findPath(nodeA, nodeB = event.getGraphView().getSelection().get(1));
                    if (nodes2 != null) {
                        event.getGraphView().unHighlightAll();
                        event.getGraphView().highlight(nodes2);
                    } else {
                        JOptionPane.showMessageDialog(null, "No path between " + nodeA.getId() + " and " + nodeB.getId() + ".");
                    }
                    event.getGraphView().deselect();
                    break;
                }
                case 4: {
                    event.getGraphView().deselect();
                    event.getGraphView().unHighlightAll();
                }
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

