/*
 * Decompiled with CFR 0.152.
 */
package pedviz.view.animations;

import pedviz.view.GraphView;

public abstract class Animation
implements Runnable {
    GraphView graphView;
    Thread thread;
    boolean pulsing = false;
    int interval = 500;

    public Animation(GraphView graphView) {
        this.graphView = graphView;
    }

    public abstract void pulse(GraphView var1);

    public void run() {
        while (this.pulsing) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                System.out.println("interrupted");
                this.pulsing = false;
            }
            if (!this.pulsing) continue;
            this.pulse(this.graphView);
        }
    }

    public void start() {
        if (!this.pulsing) {
            this.pulsing = true;
            this.thread = new Thread(this);
            this.thread.setPriority(5);
            this.thread.start();
        }
    }

    public void stop() {
        this.pulsing = false;
        this.thread = null;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }
}

