/*
 * Decompiled with CFR 0.152.
 */
package pedviz.view.rules;

import java.awt.Color;
import java.util.Vector;
import pedviz.view.NodeView;
import pedviz.view.rules.Rule;

public class ColorRule
extends Rule {
    private Vector<String> userData = new Vector();
    private Vector<Object> value = null;
    private Vector<Color> color;
    private Vector<Boolean> enabled;

    public ColorRule(String userData, Object value, Color color) {
        this.userData.add(userData);
        this.color = new Vector();
        this.color.add(color);
        this.value = new Vector();
        this.value.add(value);
        this.enabled = new Vector();
        this.enabled.add(true);
    }

    public void addRule(String userData, Object value, Color color) {
        this.userData.add(userData);
        this.color.add(color);
        this.value.add(value);
        this.enabled.add(true);
    }

    public void applyRule(NodeView nodeview) {
        if (!nodeview.getNode().isDummy()) {
            if (this.userData.size() == 1) {
                Object currentValue = nodeview.getNode().getUserData(this.userData.get(0));
                if (currentValue != null && currentValue.equals(this.value.get(0)) && this.enabled.get(0).booleanValue()) {
                    nodeview.setColor(this.color.get(0));
                }
            } else {
                Color[] colors = new Color[this.userData.size()];
                for (int i = 0; i < this.userData.size(); ++i) {
                    Object currentValue = nodeview.getNode().getUserData(this.userData.get(i));
                    if (currentValue == null || !this.enabled.get(i).booleanValue()) continue;
                    colors[i] = currentValue.equals(this.value.get(i)) ? this.color.get(i) : null;
                }
                nodeview.setColors(colors);
            }
        }
    }

    public void setEnabled(int index, boolean enabled) {
        this.enabled.set(index, enabled);
    }

    public void setCondition(int index, String trait, Object value) {
        this.value.set(index, value);
        this.userData.set(index, trait);
    }

    public void setColor(int index, Color color) {
        this.color.set(index, color);
    }

    public boolean isEnabled(int index) {
        return this.enabled.get(index);
    }
}

