/*
 * Decompiled with CFR 0.152.
 */
package pedviz.view.symbols;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import pedviz.view.NodeView;
import pedviz.view.symbols.Symbol2D;

public class SymbolGenotypes
extends Symbol2D {
    private String[] traits;
    private boolean showId = false;

    public SymbolGenotypes(String ... traits) {
        this(false, traits);
    }

    public SymbolGenotypes(boolean showId, String ... traits) {
        this.showId = showId;
        this.traits = traits;
    }

    public void drawSymbol(Graphics2D g, Point2D.Float position, float size, Color border, Color fill, NodeView nodeview) {
        float top = position.y + size / 2.0f + 0.5f;
        Font oldfont = g.getFont();
        g.setColor(border);
        Font font = new Font("default", 0, 3);
        g.setFont(font);
        float height = g.getFontMetrics().getHeight();
        float y = top + height;
        if (this.showId) {
            String text = nodeview.getNode().getId().toString();
            float width = g.getFontMetrics().stringWidth(text);
            g.drawString(text, position.x - width / 2.0f, y - (float)((int)(size * 0.5f)) / 2.0f);
            y += height;
        }
        for (String trait : this.traits) {
            String text = "??";
            if (nodeview.getNode().getUserData(trait) != null) {
                text = nodeview.getNode().getUserData(trait).toString();
            }
            float width = g.getFontMetrics().stringWidth(text);
            g.drawString(text, position.x - width / 2.0f, y - (float)((int)(size * 0.5f)) / 2.0f);
            y += height;
        }
        g.setFont(oldfont);
    }

    public int getPriority() {
        return 1;
    }

    public Float getHeight() {
        return Float.valueOf(0.5f + 4.0f * ((float)this.traits.length + (this.showId ? 1.0f : 0.0f)));
    }

    public void setTraits(String[] traits) {
        this.traits = traits;
    }
}

