/*
 * Decompiled with CFR 0.152.
 */
package pedviz.view.symbols;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import pedviz.haplotype.HaplotypeItem;
import pedviz.haplotype.Haplotypes;
import pedviz.haplotype.MerlinError;
import pedviz.view.NodeView;
import pedviz.view.symbols.Symbol2D;

public class SymbolHaplotypes
extends Symbol2D {
    private Haplotypes haplotypes;
    private boolean showId = false;
    private boolean showMarkers = true;

    public SymbolHaplotypes(Haplotypes haplotypes) {
        this(haplotypes, false);
    }

    public SymbolHaplotypes(Haplotypes haplotypes, boolean showId) {
        this.haplotypes = haplotypes;
        this.showId = showId;
    }

    public void drawSymbol(Graphics2D g, Point2D.Float position, float size, Color border, Color fill, NodeView nodeview) {
        float top = (float)(position.getY() + (double)(size / 2.0f) + 0.5);
        Font oldfont = g.getFont();
        g.setColor(border);
        Font font = new Font("default", 0, 2);
        g.setFont(font);
        float y = top;
        Vector<HaplotypeItem> data = this.haplotypes.getData(nodeview.getNode().getId());
        if (this.showId) {
            String text = nodeview.getNode().getId().toString();
            float width = g.getFontMetrics().stringWidth(text);
            g.drawString(text, position.x - width / 2.0f, y + 2.0f);
            y += 2.5f;
        }
        int fontHeight = 2;
        if (nodeview.isMouseOver() && this.showMarkers) {
            Rectangle2D.Float r2 = new Rectangle2D.Float(position.x - 25.0f - 1.5f, y, 20.0f, (float)this.haplotypes.getVisibleSize() * 2.5f + (this.showId ? 2.5f : 0.0f));
            g.setColor(new Color(230, 230, 230));
            g.fill(r2);
        }
        for (int i = 0; i < data.size(); ++i) {
            MerlinError error;
            HaplotypeItem haplotype = data.get(i);
            if (!this.haplotypes.isMarkerVisible(i)) continue;
            String text = haplotype.getDad();
            String text2 = haplotype.getMom();
            float width = g.getFontMetrics().stringWidth(text);
            float width2 = g.getFontMetrics().stringWidth(text2);
            float posxMom = position.x + 3.0f + 0.5f;
            float posxMom2 = position.x + 0.25f;
            float posxDad = position.x - 3.0f - 0.5f;
            float posxDad2 = position.x - 0.25f - 2.0f;
            if (nodeview.isMomLeft()) {
                posxMom = position.x - 3.0f - 0.5f;
                posxMom2 = position.x - 0.25f - 2.0f;
                posxDad = position.x + 3.0f + 0.5f;
                posxDad2 = position.x + 0.25f;
            }
            if ((error = this.haplotypes.getErrors().get(nodeview.getNode().getId())) != null && error.getMarker().equals(this.haplotypes.getMarkers().get(i))) {
                g.setColor(Color.RED);
            } else {
                g.setColor(Color.BLACK);
            }
            g.drawString(text, posxDad - width / 2.0f, y + 2.0f);
            g.drawString(text2, posxMom - width2 / 2.0f, y + 2.0f);
            g.setColor(Color.BLACK);
            if (nodeview.isMouseOver() && this.showMarkers) {
                String caption = this.haplotypes.getMarkers().get(i);
                if (this.haplotypes.getPos().size() >= i) {
                    String temp = this.haplotypes.getPos().get(i);
                    if (temp.length() > 6) {
                        temp = temp.substring(0, 6);
                    }
                    caption = caption + "    " + temp;
                }
                g.drawString(caption, position.x - 25.0f - 0.5f, y + 2.0f);
            }
            Rectangle2D.Float r = new Rectangle2D.Float(posxDad2, y, 2.0f, 2.7f);
            g.setColor(haplotype.getColorDad());
            g.fill(r);
            Rectangle2D.Float r2 = new Rectangle2D.Float(posxMom2, y, 2.0f, 2.7f);
            g.setColor(haplotype.getColorMom());
            g.fill(r2);
            y += 2.5f;
        }
        g.setFont(oldfont);
    }

    public int getPriority() {
        return 1;
    }

    public Float getHeight() {
        return Float.valueOf(1.0f + (float)this.haplotypes.getVisibleSize() * 2.5f + (this.showId ? 2.5f : 0.0f));
    }

    public boolean isShowMarkers() {
        return this.showMarkers;
    }

    public void setShowMarkers(boolean showMarkers) {
        this.showMarkers = showMarkers;
    }
}

