/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.AbstractAlignment;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.track.WindowFunction;

public class SamAlignment
extends AbstractAlignment
implements Alignment {
    public static final char DELETE_CHAR = '-';
    public static final char SKIP_CHAR = '=';
    public static final char MATCH = 'M';
    public static final char PERFECT_MATCH = '=';
    public static final char MISMATCH = 'X';
    public static final char INSERTION = 'I';
    public static final char DELETION = 'D';
    public static final char SKIPPED_REGION = 'N';
    public static final char SOFT_CLIP = 'S';
    public static final char HARD_CLIP = 'H';
    public static final char PADDING = 'P';
    public static final char ZERO_GAP = 'O';
    private int start;
    private int end;
    private int alignmentStart;
    private int alignmentEnd;
    boolean negativeStrand;
    boolean readNegativeStrandFlag;
    boolean duplicateReadFlag;
    boolean readUnmappedFlag;
    boolean readPairedFlag;
    boolean properPairFlag;
    SAMRecord record;
    String cigarString;
    String readSequence;
    private boolean softClippedStart = false;
    private boolean softClippedEnd = false;
    private Strand firstReadStrand = Strand.NONE;
    private Strand secondReadStrand = Strand.NONE;
    boolean firstRead = false;
    boolean secondRead = false;
    private String mateSequence = null;
    private String pairOrientation = "";
    private String readGroup;
    private String library;
    private String sample;
    private char[] tmp = new char[4];

    public SamAlignment(SAMRecord record) {
        String refName;
        this.record = record;
        this.chr = refName = record.getReferenceName();
        this.start = this.alignmentStart = record.getAlignmentStart() - 1;
        this.end = this.alignmentEnd = Math.max(this.alignmentStart, record.getAlignmentEnd());
        this.negativeStrand = record.getReadNegativeStrandFlag();
        this.cigarString = record.getCigarString();
        this.setMappingQuality(record.getMappingQuality());
        this.readName = record.getReadName().trim();
        this.readNegativeStrandFlag = record.getReadNegativeStrandFlag();
        this.duplicateReadFlag = record.getDuplicateReadFlag();
        this.readUnmappedFlag = record.getReadUnmappedFlag();
        this.readPairedFlag = record.getReadPairedFlag();
        this.setInferredInsertSize(record.getInferredInsertSize());
        this.readSequence = record.getReadString();
        this.setMatePair(record, null);
        this.setPairOrientation(record);
        this.setFirstReadStrand(record);
        this.createAlignmentBlocks(record.getCigarString(), record.getReadBases(), record.getBaseQualities());
        SAMFileHeader header = record.getHeader();
        if (header != null) {
            SAMReadGroupRecord rgRec;
            this.readGroup = (String)record.getAttribute("RG");
            if (this.readGroup != null && (rgRec = header.getReadGroup(this.readGroup)) != null) {
                String platform = rgRec.getPlatform();
                this.sample = rgRec.getSample();
                this.library = rgRec.getLibrary();
            }
        }
    }

    private void setFirstReadStrand(SAMRecord record) {
        if (!record.getReadPairedFlag()) {
            this.firstReadStrand = record.getReadNegativeStrandFlag() ? Strand.NEGATIVE : Strand.POSITIVE;
        } else if (record.getProperPairFlag()) {
            if (record.getFirstOfPairFlag()) {
                Strand strand = this.firstReadStrand = record.getReadNegativeStrandFlag() ? Strand.NEGATIVE : Strand.POSITIVE;
                if (!record.getMateUnmappedFlag()) {
                    this.secondReadStrand = record.getMateNegativeStrandFlag() ? Strand.NEGATIVE : Strand.POSITIVE;
                }
            } else {
                if (!record.getMateUnmappedFlag()) {
                    this.firstReadStrand = record.getMateNegativeStrandFlag() ? Strand.NEGATIVE : Strand.POSITIVE;
                }
                this.secondReadStrand = record.getReadNegativeStrandFlag() ? Strand.NEGATIVE : Strand.POSITIVE;
            }
        }
    }

    private void setMatePair(SAMRecord record, Genome genome) {
        if (record.getReadPairedFlag()) {
            String mateReferenceName = record.getMateReferenceName();
            String mateChr = genome == null ? mateReferenceName : genome.getChromosomeAlias(mateReferenceName);
            this.properPairFlag = record.getProperPairFlag();
            this.setMate(new ReadMate(mateChr, record.getMateAlignmentStart(), record.getMateNegativeStrandFlag(), record.getMateUnmappedFlag()));
            this.firstRead = record.getFirstOfPairFlag();
            this.secondRead = record.getSecondOfPairFlag();
        }
    }

    private void setPairOrientation(SAMRecord record) {
        if (record.getReadPairedFlag() && !this.readUnmappedFlag && !record.getMateUnmappedFlag() && record.getReferenceName().equals(record.getMateReferenceName())) {
            int s1 = record.getReadNegativeStrandFlag() ? 82 : 70;
            int s2 = record.getMateNegativeStrandFlag() ? 82 : 70;
            int o1 = 32;
            int o2 = 32;
            if (record.getFirstOfPairFlag()) {
                o1 = 49;
                o2 = 50;
            } else if (record.getSecondOfPairFlag()) {
                o1 = 50;
                o2 = 49;
            }
            if (record.getInferredInsertSize() > 0) {
                this.tmp[0] = s1;
                this.tmp[1] = o1;
                this.tmp[2] = s2;
                this.tmp[3] = o2;
            } else {
                this.tmp[2] = s1;
                this.tmp[3] = o1;
                this.tmp[0] = s2;
                this.tmp[1] = o2;
            }
            this.pairOrientation = new String(this.tmp);
        }
    }

    private SamAlignment(SamAlignment alignment) {
        this.chr = alignment.chr;
        this.alignmentStart = alignment.alignmentStart;
        this.alignmentEnd = alignment.alignmentEnd;
        this.end = alignment.end;
        this.negativeStrand = alignment.negativeStrand;
        this.mate = alignment.mate;
        this.alignmentBlocks = alignment.alignmentBlocks;
        this.insertions = alignment.insertions;
        this.cigarString = alignment.cigarString;
        this.mappingQuality = alignment.mappingQuality;
        this.readName = alignment.readName;
        this.readNegativeStrandFlag = alignment.readNegativeStrandFlag;
        this.duplicateReadFlag = alignment.duplicateReadFlag;
        this.readUnmappedFlag = alignment.readUnmappedFlag;
        this.readPairedFlag = alignment.readPairedFlag;
        this.inferredInsertSize = alignment.inferredInsertSize;
        this.properPairFlag = alignment.properPairFlag;
    }

    void createAlignmentBlocks(String cigarString, byte[] readBases, byte[] readBaseQualities) {
        boolean showSoftClipped = false;
        int nInsertions = 0;
        int nBlocks = 0;
        ArrayList<CigarOperator> operators = new ArrayList<CigarOperator>();
        StringBuffer buffer = new StringBuffer(4);
        if (cigarString.equals("*")) {
            this.alignmentBlocks = new AlignmentBlock[1];
            this.alignmentBlocks[0] = new AlignmentBlock(this.getStart(), readBases, readBaseQualities);
            return;
        }
        boolean firstOperator = true;
        int softClippedBaseCount = 0;
        int nGaps = 0;
        char prevOp = '\u0000';
        for (int i = 0; i < cigarString.length(); ++i) {
            char next = cigarString.charAt(i);
            if (Character.isDigit(next)) {
                buffer.append(next);
                continue;
            }
            char op = next;
            if (op == 'H') {
                buffer = new StringBuffer(4);
                continue;
            }
            int nBases = Integer.parseInt(buffer.toString());
            if (this.operatorIsMatch(showSoftClipped, op)) {
                if (this.operatorIsMatch(showSoftClipped, prevOp)) {
                    ++nGaps;
                }
                ++nBlocks;
            } else if (op == 'D' || op == 'N') {
                ++nGaps;
            } else if (op == 'I') {
                ++nInsertions;
                ++nGaps;
            }
            if (firstOperator && op == 'S') {
                softClippedBaseCount += nBases;
            }
            operators.add(new CigarOperator(nBases, op));
            buffer = new StringBuffer(4);
            prevOp = op;
            firstOperator = false;
        }
        this.alignmentBlocks = new AlignmentBlock[nBlocks];
        this.insertions = new AlignmentBlock[nInsertions];
        if (nGaps > 0) {
            this.gapTypes = new char[nGaps];
        }
        if (showSoftClipped) {
            this.start -= softClippedBaseCount;
        }
        int fromIdx = showSoftClipped ? 0 : softClippedBaseCount;
        int blockStart = this.start;
        int blockIdx = 0;
        int insertionIdx = 0;
        int gapIdx = 0;
        prevOp = '\u0000';
        for (CigarOperator op : operators) {
            try {
                byte[] blockQualities;
                byte[] blockBases;
                if (op.operator == 'H') continue;
                if (this.operatorIsMatch(showSoftClipped, op.operator)) {
                    blockBases = new byte[op.nBases];
                    blockQualities = new byte[op.nBases];
                    Arrays.fill(blockQualities, (byte)126);
                    int nBasesAvailable = readBases.length - fromIdx;
                    if (readBases == null || readBases.length == 0) {
                        Arrays.fill(blockBases, (byte)61);
                    } else if (nBasesAvailable < op.nBases) {
                        Arrays.fill(blockBases, (byte)63);
                    } else {
                        System.arraycopy(readBases, fromIdx, blockBases, 0, op.nBases);
                    }
                    nBasesAvailable = readBaseQualities.length - fromIdx;
                    if (readBaseQualities == null || readBaseQualities.length == 0 || nBasesAvailable < op.nBases) {
                        Arrays.fill(blockQualities, (byte)126);
                    } else {
                        System.arraycopy(readBaseQualities, fromIdx, blockQualities, 0, op.nBases);
                    }
                    AlignmentBlock block = new AlignmentBlock(blockStart, blockBases, blockQualities);
                    if (op.operator == 'S') {
                        block.setSoftClipped(true);
                    }
                    this.alignmentBlocks[blockIdx++] = block;
                    fromIdx += op.nBases;
                    blockStart += op.nBases;
                    if (this.operatorIsMatch(showSoftClipped, prevOp)) {
                        this.gapTypes[gapIdx++] = 79;
                    }
                } else if (op.operator == 'D' || op.operator == 'N') {
                    blockStart += op.nBases;
                    this.gapTypes[gapIdx++] = op.operator;
                } else if (op.operator == 'I') {
                    this.gapTypes[gapIdx++] = 79;
                    blockBases = new byte[op.nBases];
                    blockQualities = new byte[op.nBases];
                    if (readBases == null || readBases.length == 0) {
                        Arrays.fill(blockBases, (byte)61);
                    } else {
                        System.arraycopy(readBases, fromIdx, blockBases, 0, op.nBases);
                    }
                    if (readBaseQualities == null || readBaseQualities.length == 0) {
                        Arrays.fill(blockQualities, (byte)126);
                    } else {
                        System.arraycopy(readBaseQualities, fromIdx, blockQualities, 0, op.nBases);
                    }
                    this.insertions[insertionIdx++] = new AlignmentBlock(blockStart, blockBases, blockQualities);
                    fromIdx += op.nBases;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            prevOp = op.operator;
        }
        if (showSoftClipped && operators.size() > 0) {
            CigarOperator last = (CigarOperator)operators.get(operators.size() - 1);
            if (last.operator == 'S') {
                this.end += last.nBases;
            }
        }
    }

    private boolean operatorIsMatch(boolean showSoftClipped, char operator) {
        return operator == 'M' || operator == '=' || operator == 'X' || showSoftClipped && operator == 'S';
    }

    SamAlignment() {
    }

    @Override
    public boolean isNegativeStrand() {
        return this.readNegativeStrandFlag;
    }

    @Override
    public boolean isDuplicate() {
        return this.duplicateReadFlag;
    }

    @Override
    public boolean isMapped() {
        return !this.readUnmappedFlag;
    }

    @Override
    public boolean isPaired() {
        return this.readPairedFlag;
    }

    @Override
    public boolean isProperPair() {
        return this.properPairFlag;
    }

    @Override
    public LocusScore copy() {
        return new SamAlignment(this);
    }

    @Override
    public int getAlignmentStart() {
        return this.alignmentStart;
    }

    public void setUnclippedStart(int unclippedStart) {
        this.alignmentStart = unclippedStart;
    }

    @Override
    public String getCigarString() {
        return this.cigarString;
    }

    @Override
    public String getReadSequence() {
        return this.readSequence;
    }

    @Override
    public int getAlignmentEnd() {
        return this.alignmentEnd;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
        this.alignmentStart = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
        this.alignmentEnd = end;
    }

    public boolean isSoftClippedStart() {
        return this.softClippedStart;
    }

    public boolean isSoftClippedEnd() {
        return this.softClippedEnd;
    }

    @Override
    public String getSample() {
        return this.sample;
    }

    @Override
    public String getReadGroup() {
        return this.readGroup;
    }

    @Override
    public String getLibrary() {
        return this.library;
    }

    public String toString() {
        return this.record.format();
    }

    @Override
    public char[] getGapTypes() {
        return this.gapTypes;
    }

    @Override
    public Strand getFragmentStrand(int strand) {
        return strand == 1 ? this.firstReadStrand : this.secondReadStrand;
    }

    @Override
    public Object getAttribute(String key) {
        return this.record.getAttribute(key);
    }

    @Override
    public String getClipboardString(double location) {
        return this.getValueStringImpl(location, false);
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        return this.getValueStringImpl(position, true);
    }

    String getValueStringImpl(double position, boolean truncate) {
        List attributes;
        StringBuffer buf = new StringBuffer(super.getValueString(position, null));
        if (this.isPaired()) {
            if (this.record.getFirstOfPairFlag()) {
                buf.append("<br>First in pair");
            }
            if (this.record.getSecondOfPairFlag()) {
                buf.append("<br>Second in pair");
            }
            if (this.record.getNotPrimaryAlignmentFlag()) {
                buf.append("<br>Alignment NOT primary");
            }
            if (this.record.getReadFailsVendorQualityCheckFlag()) {
                buf.append("<br>FAILED Vendor Quality Check");
            }
            buf.append("<br>-------------------");
        }
        if ((attributes = this.record.getAttributes()) != null && !attributes.isEmpty()) {
            for (SAMRecord.SAMTagAndValue tag : attributes) {
                String tagValue = tag.value.toString();
                if (tagValue.length() > 50 && truncate) {
                    tagValue = tagValue.substring(0, 50) + "...";
                }
                buf.append("<br>" + tag.tag + " = " + tagValue);
            }
            buf.append("<br>-------------------");
        }
        if (this.mateSequence != null) {
            buf.append("<br>Unmapped mate sequence: " + this.mateSequence);
            buf.append("<br>-------------------");
        }
        return buf.toString();
    }

    public boolean isFirstInPair() {
        return this.record.getFirstOfPairFlag();
    }

    @Override
    public String getMateSequence() {
        return this.mateSequence;
    }

    @Override
    public void setMateSequence(String mateSequence) {
        this.mateSequence = mateSequence;
    }

    @Override
    public String getPairOrientation() {
        return this.pairOrientation;
    }

    @Override
    public boolean isVendorFailedRead() {
        return this.record.getReadFailsVendorQualityCheckFlag();
    }

    static class CigarOperator {
        int nBases;
        char operator;

        public CigarOperator(int nBases, char operator) {
            this.nBases = nBases;
            this.operator = operator;
        }
    }
}

