/*
 * Decompiled with CFR 0.152.
 */
package savant.api.data;

public final class Block {
    private final int position;
    private final int size;

    private Block(int pos, int size) {
        this.position = pos;
        this.size = size;
    }

    public static Block valueOf(int pos, int size) {
        return new Block(pos, size);
    }

    public int getPosition() {
        return this.position;
    }

    public int getSize() {
        return this.size;
    }

    public int getEnd() {
        return this.position + this.size;
    }

    public static int[] extractBlocks(String s) {
        int numBlocks;
        String[] blocks = s.split(",");
        if (blocks[(numBlocks = blocks.length) - 1].length() == 0) {
            --numBlocks;
        }
        int[] result = new int[numBlocks];
        for (int i = 0; i < numBlocks; ++i) {
            result[i] = Integer.parseInt(blocks[i]);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        if (this.position != block.position) {
            return false;
        }
        return this.size == block.size;
    }

    public int hashCode() {
        int result = this.position;
        result = 31 * result + this.size;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Block");
        sb.append("{position=").append(this.position);
        sb.append(", size=").append(this.size);
        sb.append('}');
        return sb.toString();
    }
}

