/*
 * Decompiled with CFR 0.152.
 */
package savant.api.util;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.plugin.SavantPlugin;
import savant.settings.PersistentSettings;
import savant.util.CryptoUtils;

public class SettingsUtils {
    private static final Log LOG = LogFactory.getLog(SettingsUtils.class);

    private static String makePluginKey(SavantPlugin p, String key) {
        return p.getDescriptor().getID() + "." + key;
    }

    public static Color getColour(SavantPlugin p, String key, Color dflt) {
        return PersistentSettings.getInstance().getColour(SettingsUtils.makePluginKey(p, key), dflt);
    }

    public static void setColour(SavantPlugin p, String key, Color value) {
        PersistentSettings.getInstance().setColour(SettingsUtils.makePluginKey(p, key), value);
    }

    public static boolean getBoolean(SavantPlugin p, String key, boolean dflt) {
        return PersistentSettings.getInstance().getBoolean(SettingsUtils.makePluginKey(p, key), dflt);
    }

    public static void setBoolean(SavantPlugin p, String key, boolean value) {
        PersistentSettings.getInstance().setBoolean(SettingsUtils.makePluginKey(p, key), value);
    }

    public static int getInt(SavantPlugin p, String key, int dflt) {
        return PersistentSettings.getInstance().getInt(SettingsUtils.makePluginKey(p, key), dflt);
    }

    public static void setInt(SavantPlugin p, String key, int value) {
        PersistentSettings.getInstance().setInt(SettingsUtils.makePluginKey(p, key), value);
    }

    public static File getFile(SavantPlugin p, String key) {
        return PersistentSettings.getInstance().getFile(SettingsUtils.makePluginKey(p, key));
    }

    public static void setFile(SavantPlugin p, String key, File value) {
        PersistentSettings.getInstance().setFile(SettingsUtils.makePluginKey(p, key), value);
    }

    public static String getString(SavantPlugin p, String key) {
        return PersistentSettings.getInstance().getString(SettingsUtils.makePluginKey(p, key));
    }

    public static void setString(SavantPlugin p, String key, String value) {
        PersistentSettings.getInstance().setString(SettingsUtils.makePluginKey(p, key), value);
    }

    public static String getPassword(SavantPlugin p, String key) {
        String s = PersistentSettings.getInstance().getString(SettingsUtils.makePluginKey(p, key));
        return s != null ? CryptoUtils.decrypt(s) : null;
    }

    public static void setPassword(SavantPlugin p, String key, String value) {
        PersistentSettings.getInstance().setString(SettingsUtils.makePluginKey(p, key), CryptoUtils.encrypt(value));
    }

    public static void store() {
        try {
            PersistentSettings.getInstance().store();
        }
        catch (IOException iox) {
            LOG.error((Object)"Unable to write settings for plugin.", (Throwable)iox);
        }
    }
}

