/*
 * Decompiled with CFR 0.152.
 */
package savant.api.util;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import savant.api.adapter.DataSourceAdapter;
import savant.api.adapter.TrackAdapter;
import savant.api.data.DataFormat;
import savant.api.event.TrackEvent;
import savant.api.util.Listener;
import savant.controller.FrameController;
import savant.controller.TrackController;
import savant.view.swing.DockableFrameFactory;
import savant.view.swing.Frame;
import savant.view.tracks.Track;
import savant.view.tracks.TrackFactory;

public class TrackUtils {
    private static TrackController trackController = TrackController.getInstance();

    public static TrackAdapter[] getTracks() {
        int numTracks = trackController.getTracks().size();
        TrackAdapter[] result = new TrackAdapter[numTracks];
        for (int i = 0; i < numTracks; ++i) {
            result[i] = trackController.getTrack(i);
        }
        return result;
    }

    public static void addTrack(TrackAdapter track) {
        TrackUtils.addTracks(Arrays.asList(track));
    }

    public static void addTracks(List<TrackAdapter> tracks) {
        Track[] myTracks = new Track[tracks.size()];
        for (int i = 0; i < tracks.size(); ++i) {
            myTracks[i] = (Track)tracks.get(i);
        }
        Frame f = DockableFrameFactory.createTrackFrame(myTracks[0].getDataFormat());
        f.setTracks(myTracks);
    }

    public static TrackAdapter createTrack(DataSourceAdapter ds) throws Throwable {
        return TrackFactory.createTrack(ds);
    }

    public static TrackAdapter[] createTrack(URI uri) throws Throwable {
        Frame f = FrameController.getInstance().addTrackFromURI(uri, null, null);
        return f.getTracks();
    }

    public static TrackAdapter[] createTrack(File file) throws Throwable {
        Frame f = FrameController.getInstance().addTrackFromURI(file.toURI(), null, null);
        return f.getTracks();
    }

    public static DataSourceAdapter getTrackDataSource(String trackName) {
        TrackAdapter t = TrackUtils.getTrack(trackName);
        if (t == null) {
            return null;
        }
        return t.getDataSource();
    }

    public static TrackAdapter[] getTracks(DataFormat kind) {
        ArrayList<Track> r = new ArrayList<Track>();
        for (Track t : trackController.getTracks(kind)) {
            r.add(t);
        }
        return r.toArray(new TrackAdapter[0]);
    }

    public static synchronized void addTrackListener(Listener<TrackEvent> l) {
        trackController.addListener(l);
    }

    public static synchronized void removeTrackListener(Listener<TrackEvent> l) {
        trackController.removeListener(l);
    }

    public static TrackAdapter getTrack(String trackName) {
        return trackController.getTrack(trackName);
    }
}

