/*
 * Decompiled with CFR 0.152.
 */
package savant.controller;

import java.util.ArrayList;
import java.util.List;
import savant.api.adapter.GraphPaneAdapter;
import savant.api.util.NavigationUtils;
import savant.controller.event.GraphPaneEvent;
import savant.util.Controller;

public class GraphPaneController
extends Controller {
    private boolean spotlit;
    private boolean plumbing;
    private boolean zooming;
    private boolean aiming;
    private boolean panning;
    private boolean selecting;
    private int mouseClickPosition;
    private int mouseReleasePosition;
    private int mouseXPosition;
    private double mouseYPosition;
    private boolean yIntegral;
    private List<GraphPaneAdapter> graphpanesQueuedForRendering = new ArrayList<GraphPaneAdapter>();
    private int spotlightSize;
    private static GraphPaneController instance;
    long start;

    public void clearRenderingList() {
        this.graphpanesQueuedForRendering.clear();
    }

    public void enlistRenderingGraphpane(GraphPaneAdapter p) {
        this.graphpanesQueuedForRendering.add(p);
        if (this.graphpanesQueuedForRendering.size() == 1) {
            this.fireEvent(new GraphPaneEvent("rendering..."));
            this.start = System.currentTimeMillis();
        }
    }

    public void delistRenderingGraphpane(GraphPaneAdapter p) {
        if (!this.graphpanesQueuedForRendering.contains(p)) {
            return;
        }
        if (this.graphpanesQueuedForRendering.isEmpty()) {
            return;
        }
        this.graphpanesQueuedForRendering.remove(p);
        if (this.graphpanesQueuedForRendering.isEmpty()) {
            long elapsedTimeMillis = System.currentTimeMillis() - this.start;
            float elapsedTimeSec = (float)elapsedTimeMillis * 0.001f;
            this.fireEvent(new GraphPaneEvent(String.format("took %.3f s", Float.valueOf(elapsedTimeSec))));
            NavigationUtils.fireLocationChangeCompletedEvent();
        }
    }

    private GraphPaneController() {
    }

    public static synchronized GraphPaneController getInstance() {
        if (instance == null) {
            instance = new GraphPaneController();
        }
        return instance;
    }

    public void askForRefresh() {
        if (this.isPanning() || this.isZooming() || this.isPlumbing() || this.isSpotlight() || this.isAiming() || this.isSelecting()) {
            this.fireEvent(new GraphPaneEvent());
        }
    }

    public void forceRefresh() {
        this.fireEvent(new GraphPaneEvent());
    }

    public boolean isSelecting() {
        return this.selecting;
    }

    public void setSelecting(boolean value) {
        this.selecting = value;
    }

    public boolean isPlumbing() {
        return this.plumbing;
    }

    public void setPlumbing(boolean value) {
        if (this.plumbing != value) {
            this.plumbing = value;
            if (value) {
                this.spotlit = false;
                this.aiming = false;
            }
            this.forceRefresh();
        }
    }

    public boolean isSpotlight() {
        return this.spotlit;
    }

    public void setSpotlight(boolean value) {
        if (this.spotlit != value) {
            this.spotlit = value;
            if (value) {
                this.plumbing = false;
                this.aiming = false;
            }
            this.forceRefresh();
        }
    }

    public boolean isZooming() {
        return this.zooming;
    }

    public void setZooming(boolean value) {
        if (this.zooming != value) {
            this.zooming = value;
            this.forceRefresh();
        }
    }

    public boolean isAiming() {
        return this.aiming;
    }

    public void setAiming(boolean value) {
        if (this.aiming != value) {
            this.aiming = value;
            if (value) {
                this.plumbing = false;
                this.spotlit = false;
            }
            this.forceRefresh();
        }
    }

    public boolean isPanning() {
        return this.panning;
    }

    public void setPanning(boolean value) {
        if (this.panning != value) {
            this.panning = value;
            this.forceRefresh();
        }
    }

    public int getMouseClickPosition() {
        return this.mouseClickPosition;
    }

    public void setMouseClickPosition(int position) {
        this.mouseClickPosition = position;
        this.askForRefresh();
    }

    public int getMouseReleasePosition() {
        return this.mouseReleasePosition;
    }

    public void setMouseReleasePosition(int position) {
        this.mouseReleasePosition = position;
        this.askForRefresh();
    }

    public int getMouseXPosition() {
        return this.mouseXPosition;
    }

    public void setMouseXPosition(int x) {
        this.mouseXPosition = x;
        this.askForRefresh();
        this.fireEvent(new GraphPaneEvent(this.mouseXPosition, this.mouseYPosition, this.yIntegral));
    }

    public double getMouseYPosition() {
        return this.mouseYPosition;
    }

    public void setMouseYPosition(double y, boolean integral) {
        this.mouseYPosition = y;
        this.yIntegral = integral;
        this.askForRefresh();
        this.fireEvent(new GraphPaneEvent(this.mouseXPosition, this.mouseYPosition, integral));
    }

    public void setSpotlightSize(int size) {
        this.spotlightSize = 1;
    }

    public int getSpotlightSize() {
        return this.spotlightSize;
    }
}

