/*
 * Decompiled with CFR 0.152.
 */
package savant.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.DataSourceAdapter;
import savant.api.adapter.TrackAdapter;
import savant.api.event.TrackEvent;
import savant.api.util.DialogUtils;
import savant.api.util.Listener;
import savant.controller.FrameController;
import savant.controller.TrackController;
import savant.settings.DirectorySettings;
import savant.util.NetworkUtils;
import savant.view.tracks.BAMCoverageTrack;

public class RecentTracksController {
    private static final Log LOG = LogFactory.getLog(RecentTracksController.class);
    private static RecentTracksController instance;
    private static final String RECENT_TRACKS_FILE = ".recent_tracks";
    private final int NUM_RECENTS_TO_SAVE = 10;
    JMenu menu;
    LinkedList<String> queue;
    private File recentTracksFile;

    public static RecentTracksController getInstance() throws IOException {
        if (instance == null) {
            instance = new RecentTracksController();
        }
        return instance;
    }

    private RecentTracksController() throws IOException {
        TrackController.getInstance().addListener(new Listener<TrackEvent>(){

            @Override
            public void handleEvent(TrackEvent event) {
                if (event.getType() == TrackEvent.Type.ADDED) {
                    TrackAdapter t = event.getTrack();
                    if (t instanceof BAMCoverageTrack) {
                        return;
                    }
                    DataSourceAdapter ds = t.getDataSource();
                    if (ds == null || ds.getURI() == null) {
                        return;
                    }
                    String path = NetworkUtils.getNeatPathFromURI(ds.getURI());
                    RecentTracksController.this.queue.remove(path);
                    RecentTracksController.this.resizeQueue(RecentTracksController.this.queue, 10);
                    RecentTracksController.this.queue.add(0, path);
                    RecentTracksController.this.updateMenuList();
                    try {
                        RecentTracksController.this.saveRecents(RecentTracksController.this.queue);
                    }
                    catch (IOException ex) {
                        LOG.error((Object)"Could not save recents to file", (Throwable)ex);
                    }
                }
            }
        });
        this.recentTracksFile = new File(DirectorySettings.getSavantDirectory(), RECENT_TRACKS_FILE);
        if (!this.recentTracksFile.exists()) {
            this.recentTracksFile.createNewFile();
        }
        this.queue = new LinkedList();
        this.loadRecents(this.recentTracksFile);
    }

    public List<String> getRecentTracks() {
        return this.queue;
    }

    private void resizeQueue(LinkedList queue, int size) {
        while (queue.size() > size) {
            queue.removeLast();
        }
    }

    public void populateMenu(JMenu m) {
        this.menu = m;
        this.updateMenuList();
    }

    private void updateMenuList() {
        this.menu.removeAll();
        for (final String s : this.queue) {
            JMenuItem item = new JMenuItem();
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        FrameController.getInstance().addTrackFromPath(s, null, null);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Unable to open file.", (Throwable)ex);
                        DialogUtils.displayError("Problem opening track from file " + s);
                    }
                }
            });
            item.setText(s);
            this.menu.add(item);
        }
        this.menu.add(new JSeparator());
        JMenuItem item = new JMenuItem();
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RecentTracksController.getInstance().clearRecents();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        item.setText("Clear Recents");
        this.menu.add(item);
    }

    private void clearRecents() {
        while (!this.queue.isEmpty()) {
            this.queue.remove(0);
        }
        try {
            this.saveRecents(this.queue);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.updateMenuList();
    }

    private void saveRecents(LinkedList<String> queue) throws IOException {
        this.recentTracksFile.delete();
        this.recentTracksFile.createNewFile();
        BufferedWriter w = new BufferedWriter(new FileWriter(this.recentTracksFile));
        for (String s : queue) {
            w.write(s + "\n");
        }
        w.close();
    }

    private void loadRecents(File f) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(f));
        String line = "";
        while ((line = r.readLine()) != null) {
            this.queue.add(line);
        }
        r.close();
    }
}

