/*
 * Decompiled with CFR 0.152.
 */
package savant.data.filters;

import net.sf.samtools.SAMRecord;
import savant.api.adapter.RecordFilterAdapter;
import savant.controller.LocationController;
import savant.data.types.BAMIntervalRecord;

public class BAMRecordFilter
implements RecordFilterAdapter<BAMIntervalRecord> {
    public static final double DEFAULT_ARC_LENGTH_THRESHOLD = 1.0;
    private double arcLengthThreshold = 1.0;
    private boolean includeDuplicates = false;
    private boolean includeVendorFailed = false;
    private boolean includePaired = true;
    private boolean includeUnpaired = true;
    private boolean includeUnmappedMate = true;
    private int mappingQualityThreshold;
    private boolean arcMode;

    public double getArcLengthThreshold() {
        return this.arcLengthThreshold;
    }

    public void setArcLengthThreshold(double value) {
        this.arcLengthThreshold = value;
    }

    public int getMappingQualityThreshold() {
        return this.mappingQualityThreshold;
    }

    public void setMappingQualityThreshold(int value) {
        this.mappingQualityThreshold = value;
    }

    public boolean getIncludeDuplicateReads() {
        return this.includeDuplicates;
    }

    public void setIncludeDuplicateReads(boolean value) {
        this.includeDuplicates = value;
    }

    public boolean getIncludeVendorFailedReads() {
        return this.includeVendorFailed;
    }

    public void setIncludeVendorFailedReads(boolean value) {
        this.includeVendorFailed = value;
    }

    public boolean getIncludePairedReads() {
        return this.includePaired;
    }

    public void setIncludePairedReads(boolean value) {
        this.includePaired = value;
    }

    public boolean getIncludeUnmappedMate() {
        return this.includeUnmappedMate;
    }

    public void setIncludeUnmappedMate(boolean value) {
        this.includeUnmappedMate = value;
    }

    public boolean getIncludeUnpairedReads() {
        return this.includeUnpaired;
    }

    public void setIncludeUnpairedReads(boolean value) {
        this.includeUnpaired = value;
    }

    public void setArcMode(boolean value) {
        this.arcMode = value;
    }

    @Override
    public boolean accept(BAMIntervalRecord rec) {
        SAMRecord samRecord = rec.getSAMRecord();
        if (!this.includeDuplicates && samRecord.getDuplicateReadFlag()) {
            return false;
        }
        if (!this.includeVendorFailed && samRecord.getReadFailsVendorQualityCheckFlag()) {
            return false;
        }
        if (samRecord.getReadPairedFlag()) {
            if (!this.includePaired) {
                return false;
            }
            if (!this.includeUnmappedMate && samRecord.getMateUnmappedFlag()) {
                return false;
            }
        } else if (!this.includeUnpaired) {
            return false;
        }
        if (samRecord.getMappingQuality() < this.mappingQualityThreshold) {
            return false;
        }
        if (this.arcMode) {
            int arcLength = Math.abs(samRecord.getInferredInsertSize());
            if (this.arcLengthThreshold != 0.0 && this.arcLengthThreshold < 1.0 && (double)arcLength < (double)LocationController.getInstance().getRange().getLength() * this.arcLengthThreshold || this.arcLengthThreshold > 1.0 && (double)arcLength < this.arcLengthThreshold) {
                return false;
            }
        }
        return true;
    }
}

