/*
 * Decompiled with CFR 0.152.
 */
package savant.data.sources;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.RecordFilterAdapter;
import savant.api.data.DataFormat;
import savant.api.util.Resolution;
import savant.data.sources.DataSource;
import savant.data.types.GenericContinuousRecord;
import savant.file.FileType;
import savant.file.SavantFileNotFormattedException;
import savant.file.SavantROFile;
import savant.format.ContinuousFormatterHelper;
import savant.util.MiscUtils;
import savant.util.Range;
import savant.util.SavantFileUtils;

public class GenericContinuousDataSource
extends DataSource<GenericContinuousRecord> {
    private static final Log LOG = LogFactory.getLog(GenericContinuousDataSource.class);
    private SavantROFile savantFile;
    private int recordSize;
    private Map<String, List<ContinuousFormatterHelper.Level>> refnameToLevelsIndex;

    public GenericContinuousDataSource(URI uri) throws IOException, SavantFileNotFormattedException {
        this.savantFile = new SavantROFile(uri, FileType.CONTINUOUS_GENERIC);
        this.refnameToLevelsIndex = ContinuousFormatterHelper.readLevelHeaders(this.savantFile);
        this.printLevelsMap(this.refnameToLevelsIndex);
        this.setRecordSize();
    }

    private ContinuousFormatterHelper.Level getBestLevel(List<ContinuousFormatterHelper.Level> levels, Range r) {
        for (int i = levels.size() - 1; i > 0; --i) {
            ContinuousFormatterHelper.Level lev = levels.get(i);
            if ((long)r.getLength() <= lev.resolution * 1000L / 2L) continue;
            return lev;
        }
        return levels.get(0);
    }

    public List<GenericContinuousRecord> getRecords(String ref, RangeAdapter r, Resolution ignored, RecordFilterAdapter filt) throws IOException {
        ArrayList<GenericContinuousRecord> data = new ArrayList<GenericContinuousRecord>();
        if (!this.savantFile.containsDataForReference(ref) && !this.savantFile.containsDataForReference(ref = MiscUtils.homogenizeSequence(ref))) {
            return data;
        }
        ContinuousFormatterHelper.Level lev = this.getBestLevel(this.refnameToLevelsIndex.get(ref), (Range)r);
        LOG.debug((Object)("Chose " + lev.resolution + " as the best for range (" + r.getFrom() + "-" + r.getTo() + ")"));
        int rangeEnd = r.getTo() + 1;
        long seekPos = lev.offset + (long)(r.getFrom() - 1) / lev.resolution * (long)this.recordSize;
        if (this.savantFile.seek(ref, seekPos) >= 0L) {
            LOG.debug((Object)("Sought to " + seekPos + " to find data for " + r.getFrom()));
            int pos = r.getFrom();
            while (pos <= rangeEnd) {
                data.add(GenericContinuousRecord.valueOf(ref, pos, this.savantFile.readFloat()));
                if (this.savantFile.getFilePointer() >= this.savantFile.getHeaderOffset() + this.savantFile.getReferenceOffset(ref) + lev.offset + lev.size) {
                    LOG.debug((Object)("File position " + this.savantFile.getFilePointer() + " was past end of level (" + (this.savantFile.getHeaderOffset() + this.savantFile.getReferenceOffset(ref) + lev.offset + lev.size) + ")."));
                    break;
                }
                pos = (int)((long)pos + lev.resolution);
            }
        }
        return data;
    }

    @Override
    public void close() {
        try {
            if (this.savantFile != null) {
                this.savantFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    public final void setRecordSize() throws IOException {
        this.recordSize = SavantFileUtils.getRecordSize(this.savantFile);
        LOG.debug((Object)("Setting record size to " + this.recordSize));
    }

    @Override
    public Set<String> getReferenceNames() {
        return this.savantFile.getReferenceMap().keySet();
    }

    private void printLevelsMap(Map<String, List<ContinuousFormatterHelper.Level>> refnameToLevelsIndex) {
        if (LOG.isDebugEnabled()) {
            for (String refname : refnameToLevelsIndex.keySet()) {
                LOG.debug((Object)("Level header for reference " + refname));
                LOG.debug((Object)("Levels list " + refnameToLevelsIndex.get(refname)));
                LOG.debug((Object)("Number of levels " + refnameToLevelsIndex.get(refname).size()));
                for (ContinuousFormatterHelper.Level l : refnameToLevelsIndex.get(refname)) {
                    LOG.debug((Object)("Offset: " + l.offset));
                    LOG.debug((Object)("Size: " + l.size));
                    LOG.debug((Object)("Record size: " + l.recordSize));
                    LOG.debug((Object)("Type: " + (Object)((Object)l.mode.type)));
                }
            }
        }
    }

    @Override
    public URI getURI() {
        return this.savantFile.getURI();
    }

    @Override
    public final DataFormat getDataFormat() {
        return DataFormat.CONTINUOUS;
    }

    @Override
    public final String[] getColumnNames() {
        return GenericContinuousRecord.COLUMN_NAMES;
    }
}

