/*
 * Decompiled with CFR 0.152.
 */
package savant.data.sources;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.RecordFilterAdapter;
import savant.api.data.DataFormat;
import savant.api.data.IntervalRecord;
import savant.api.util.Resolution;
import savant.data.sources.DataSource;
import savant.data.types.GenericIntervalRecord;
import savant.file.FileType;
import savant.file.SavantFileNotFormattedException;
import savant.file.SavantROFile;
import savant.format.IntervalRecordGetter;
import savant.format.IntervalSearchTree;
import savant.format.SavantFileFormatter;
import savant.util.Range;

public class GenericIntervalDataSource
extends DataSource<GenericIntervalRecord> {
    private static Log LOG = LogFactory.getLog(GenericIntervalDataSource.class);
    private SavantROFile dFile;
    private Map<String, IntervalSearchTree> refnameToIntervalBSTIndex;

    public GenericIntervalDataSource(URI uri) throws IOException, SavantFileNotFormattedException {
        this.dFile = new SavantROFile(uri, FileType.INTERVAL_GENERIC);
        this.refnameToIntervalBSTIndex = SavantFileFormatter.readIntervalBSTs(this.dFile);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HEADER SIZE && : " + this.dFile.getFilePointer()));
            LOG.debug((Object)"Found indices for:");
            for (String refname : this.refnameToIntervalBSTIndex.keySet()) {
                LOG.debug((Object)refname);
            }
        }
    }

    public IntervalSearchTree getIntervalSearchTreeForReference(String refname) {
        return this.refnameToIntervalBSTIndex.get(refname);
    }

    public List<GenericIntervalRecord> getRecords(String reference, RangeAdapter range, Resolution resolution, RecordFilterAdapter filt) throws IOException {
        IntervalSearchTree ist = this.getIntervalSearchTreeForReference(reference);
        if (ist == null) {
            return new ArrayList<GenericIntervalRecord>();
        }
        List<IntervalRecord> data = IntervalRecordGetter.getData(this.dFile, reference, (Range)range, ist.getRoot());
        ArrayList<GenericIntervalRecord> girList = new ArrayList<GenericIntervalRecord>(data.size());
        for (int i = 0; i < data.size(); ++i) {
            girList.add((GenericIntervalRecord)data.get(i));
        }
        return girList;
    }

    @Override
    public void close() {
        try {
            this.dFile.close();
        }
        catch (IOException ex) {
            LOG.warn((Object)("Error closing " + this.dFile), (Throwable)ex);
        }
    }

    @Override
    public Set<String> getReferenceNames() {
        return this.dFile.getReferenceMap().keySet();
    }

    @Override
    public URI getURI() {
        return this.dFile.getURI();
    }

    @Override
    public final DataFormat getDataFormat() {
        return DataFormat.GENERIC_INTERVAL;
    }

    @Override
    public final String[] getColumnNames() {
        return GenericIntervalRecord.COLUMN_NAMES;
    }
}

