/*
 * Decompiled with CFR 0.152.
 */
package savant.data.sources;

import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.RecordFilterAdapter;
import savant.api.data.DataFormat;
import savant.api.util.Resolution;
import savant.data.sources.DataSource;
import savant.data.types.GenericPointRecord;
import savant.file.FileType;
import savant.file.SavantFileNotFormattedException;
import savant.file.SavantROFile;
import savant.util.SavantFileUtils;

public class GenericPointDataSource
extends DataSource<GenericPointRecord> {
    private SavantROFile savantFile;
    private int recordSize;

    public GenericPointDataSource(URI uri) throws IOException, SavantFileNotFormattedException {
        this.savantFile = new SavantROFile(uri, FileType.POINT_GENERIC);
        this.recordSize = SavantFileUtils.getRecordSize(this.savantFile);
    }

    private GenericPointRecord convertRecordToGenericPointRecord(List<Object> record) {
        return GenericPointRecord.valueOf((String)record.get(0), (Integer)record.get(1), (String)record.get(2));
    }

    public List<GenericPointRecord> getRecords(String reference, RangeAdapter range, Resolution resolution, RecordFilterAdapter filt) throws IOException {
        ArrayList<GenericPointRecord> data = new ArrayList<GenericPointRecord>();
        if (!this.savantFile.containsDataForReference(reference)) {
            return data;
        }
        try {
            long indexOfStart = this.seekToStart(reference, range.getFrom(), 0L, this.getNumRecords(reference), this.savantFile);
            while (true) {
                this.savantFile.seek(reference, indexOfStart++ * (long)this.getRecordSize());
                List<Object> record = SavantFileUtils.readBinaryRecord(this.savantFile, this.savantFile.getFields());
                GenericPointRecord p = this.convertRecordToGenericPointRecord(record);
                int pnt = p.getPosition();
                if (pnt <= range.getTo() && p.getReference().trim().equals(reference)) {
                    data.add(p);
                    continue;
                }
                break;
            }
        }
        catch (EOFException ignore) {
            // empty catch block
        }
        return data;
    }

    @Override
    public void close() {
        try {
            if (this.savantFile != null) {
                this.savantFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getRecordSize() {
        return this.recordSize;
    }

    private int getNumRecords(String reference) {
        if (!this.savantFile.containsDataForReference(reference)) {
            return -1;
        }
        return (int)(this.savantFile.getReferenceLength(reference) / (long)this.getRecordSize());
    }

    private long seekToStart(String reference, long pos, long low, long high, SavantROFile rof) throws IOException {
        long mid = low + (high - low) / 2L;
        if (high < low) {
            return low;
        }
        int posAtMid = this.getStartPosOfRecord(reference, mid, rof);
        if ((long)posAtMid > pos) {
            return this.seekToStart(reference, pos, low, mid - 1L, rof);
        }
        if ((long)posAtMid < pos) {
            return this.seekToStart(reference, pos, mid + 1L, high, rof);
        }
        return low;
    }

    private int getStartPosOfRecord(String reference, long record_num, SavantROFile br) throws IOException {
        br.seek(reference, record_num * (long)this.getRecordSize());
        List<Object> line = SavantFileUtils.readBinaryRecord(this.savantFile, this.savantFile.getFields());
        br.seek(reference, record_num * (long)this.getRecordSize());
        return (Integer)line.get(1);
    }

    @Override
    public Set<String> getReferenceNames() {
        return this.savantFile.getReferenceMap().keySet();
    }

    @Override
    public URI getURI() {
        return this.savantFile.getURI();
    }

    @Override
    public final DataFormat getDataFormat() {
        return DataFormat.POINT;
    }

    @Override
    public final String[] getColumnNames() {
        return new String[]{"Reference", "Position", "Description"};
    }
}

