/*
 * Decompiled with CFR 0.152.
 */
package savant.data.sources;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.RecordFilterAdapter;
import savant.api.adapter.SequenceDataSourceAdapter;
import savant.api.data.DataFormat;
import savant.api.data.SequenceRecord;
import savant.api.util.Resolution;
import savant.data.sources.DataSource;
import savant.file.FileType;
import savant.file.SavantFileNotFormattedException;
import savant.file.SavantROFile;

public class OldFastaDataSource
extends DataSource<SequenceRecord>
implements SequenceDataSourceAdapter {
    private int length = -1;
    private SavantROFile dFile;

    public OldFastaDataSource(URI uri) throws IOException, SavantFileNotFormattedException {
        this.dFile = new SavantROFile(uri, FileType.SEQUENCE_FASTA);
    }

    @Override
    public int getLength(String refname) {
        if (this.dFile == null) {
            this.length = -1;
        }
        long[] vals = this.getReferenceMap().get(refname);
        this.length = (int)(vals[1] / 1L);
        return this.length;
    }

    public List<SequenceRecord> getRecords(String reference, RangeAdapter range, Resolution resolution, RecordFilterAdapter filt) throws IOException {
        int rangeLength = range.getLength();
        byte[] sequence = new byte[rangeLength];
        if (this.getReferenceMap().containsKey(reference)) {
            this.dFile.seek(reference, 1 * range.getFrom() - 1);
            for (int i = 0; i < rangeLength; ++i) {
                try {
                    sequence[i] = (byte)Character.toUpperCase(this.dFile.readByte());
                    continue;
                }
                catch (IOException e) {
                    break;
                }
            }
        } else {
            return null;
        }
        ArrayList<SequenceRecord> result = new ArrayList<SequenceRecord>();
        result.add(SequenceRecord.valueOf(reference, sequence));
        return result;
    }

    @Override
    public void close() {
        if (this.dFile != null) {
            try {
                this.dFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public Set<String> getReferenceNames() {
        return this.getReferenceMap().keySet();
    }

    private Map<String, long[]> getReferenceMap() {
        return this.dFile.getReferenceMap();
    }

    @Override
    public URI getURI() {
        return this.dFile.getURI();
    }

    @Override
    public final DataFormat getDataFormat() {
        return DataFormat.SEQUENCE;
    }

    @Override
    public final String[] getColumnNames() {
        return new String[]{"Sequence"};
    }
}

