/*
 * Decompiled with CFR 0.152.
 */
package savant.data.sources;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.SeekableStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broad.tabix.TabixReader;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.RecordFilterAdapter;
import savant.api.adapter.VariantDataSourceAdapter;
import savant.api.data.DataFormat;
import savant.api.util.Resolution;
import savant.data.sources.DataSource;
import savant.data.types.GFFIntervalRecord;
import savant.data.types.TabixIntervalRecord;
import savant.util.ColumnMapping;
import savant.util.IndexCache;
import savant.util.MiscUtils;
import savant.util.NetworkUtils;

public class TabixDataSource
extends DataSource<TabixIntervalRecord>
implements VariantDataSourceAdapter {
    private static final Log LOG = LogFactory.getLog(TabixDataSource.class);
    TabixReader reader;
    ColumnMapping mapping;
    String[] columnNames;
    String[] extraColumns;
    private URI uri;

    public TabixDataSource(URI uri) throws IOException {
        File indexFile = IndexCache.getIndexFile(uri, "tbi", "gz");
        SeekableStream baseStream = NetworkUtils.getSeekableStreamForURI(uri);
        this.uri = uri.normalize();
        this.reader = new TabixReader(baseStream, indexFile);
        this.inferMapping();
    }

    private void inferMapping() throws IOException {
        BlockCompressedInputStream input = new BlockCompressedInputStream(NetworkUtils.getSeekableStreamForURI(this.uri));
        String line = TabixReader.readLine((InputStream)input);
        if (line == null) {
            throw new EOFException("End of file");
        }
        String lastCommentLine = null;
        String commentChar = Character.toString(this.reader.getCommentChar());
        while (line.startsWith(commentChar)) {
            lastCommentLine = line;
            line = TabixReader.readLine((InputStream)input);
        }
        input.close();
        int numCols = 1;
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++numCols;
        }
        if (this.matchesMapping(ColumnMapping.BED)) {
            this.columnNames = new String[]{"chrom", "start", "end", "name", "score", "strand", "thickStart", "thickEnd", "itemRgb", "blockCount", "blockStarts", "blockSizes"};
        } else if (this.matchesMapping(ColumnMapping.KNOWNGENE)) {
            this.columnNames = new String[]{"Name", "Reference", "Strand", "Transcription start", "Transcription end", "Coding start", "Coding end", null, null, null, "Unique ID", "Alternate name", null, null, null};
            this.mapping = ColumnMapping.KNOWNGENE;
        } else if (this.matchesMapping(ColumnMapping.REFSEQ) && numCols == 16) {
            this.columnNames = new String[]{null, "Transcript name", "Reference", "Strand", "Transcription start", "Transcription end", "Coding start", "Coding end", null, null, null, "Unique ID", "Gene name", null, null, null};
            this.mapping = ColumnMapping.REFSEQ;
        } else if (this.matchesMapping(ColumnMapping.GFF)) {
            String attributes = line.substring(line.lastIndexOf(9) + 1);
            if (attributes.contains("gene_id") && attributes.contains("transcript_id")) {
                this.columnNames = new String[]{"Reference", "Source", "Feature", "Start", "End", "Score", "Strand", "Frame", "Attributes"};
                this.mapping = ColumnMapping.GTF;
            } else {
                this.columnNames = new String[]{"Reference", "Source", "Feature", "Start", "End", "Score", "Strand", "Frame", "Group"};
                this.mapping = ColumnMapping.GFF;
            }
        } else if (this.matchesMapping(ColumnMapping.PSL)) {
            this.columnNames = new String[]{"Matches", "Mismatches", "Matches that are part of repeats", "Number of 'N' bases", "Number of inserts in query", "Number of bases inserted in query", "Number of inserts in target", "Number of bases inserted in target", "Strand", "Query sequence name", "Query sequence size", "Alignment start in query", "Alignment end in query", "Target sequence name", "Target sequence size", "Alignment start in target", "Alignment end in target", null, null, null};
            this.mapping = ColumnMapping.PSL;
        } else if (this.matchesMapping(ColumnMapping.VCF)) {
            this.columnNames = new String[]{"Reference", "Position", "ID", "Reference base(s)", "Alternate non-reference alleles", "Quality", "Filter", "Additional information", "Format"};
            this.mapping = ColumnMapping.VCF;
        }
        if (lastCommentLine != null) {
            if (this.mapping == null) {
                this.columnNames = lastCommentLine.substring(1).split("\\t");
                this.columnNames[this.reader.getChromColumn()] = "chrom";
                this.columnNames[this.reader.getStartColumn()] = "start";
                if (this.reader.getEndColumn() >= 0) {
                    this.columnNames[this.reader.getEndColumn()] = "end";
                }
                this.mapping = ColumnMapping.inferMapping(this.columnNames, false);
            } else if (this.mapping == ColumnMapping.VCF) {
                String[] allColumns = lastCommentLine.substring(1).split("\\t");
                if (allColumns.length > this.columnNames.length) {
                    this.extraColumns = new String[allColumns.length - this.columnNames.length];
                    for (int i = this.columnNames.length; i < allColumns.length; ++i) {
                        this.extraColumns[i - this.columnNames.length] = allColumns[i];
                    }
                } else {
                    this.extraColumns = new String[0];
                }
            }
        }
    }

    private boolean matchesMapping(ColumnMapping mapping) {
        return this.reader.getChromColumn() == mapping.chrom && this.reader.getStartColumn() == mapping.start && this.reader.getEndColumn() == mapping.end;
    }

    public List<TabixIntervalRecord> getRecords(String ref, RangeAdapter r, Resolution res, RecordFilterAdapter filt) throws IOException, InterruptedException {
        ArrayList<TabixIntervalRecord> result = new ArrayList<TabixIntervalRecord>();
        try {
            TabixReader.Iterator i = this.reader.query(MiscUtils.homogenizeSequence(ref) + ":" + r.getFrom() + "-" + (r.getTo() + 1));
            if (i != null) {
                String line = null;
                int start = -1;
                int end = -1;
                HashMap<Integer, Integer> ends = new HashMap<Integer, Integer>();
                while ((line = i.next()) != null) {
                    TabixIntervalRecord rec = TabixIntervalRecord.valueOf(line, this.mapping);
                    if (filt == null || filt.accept(rec)) {
                        RangeAdapter r2 = rec.getExpandedRange(r);
                        if (r2 != null) {
                            return this.getRecords(ref, r2, res, filt);
                        }
                        if (rec.getInterval().getStart() == start) {
                            end = rec.getInterval().getEnd();
                            if (ends.get(end) == null) {
                                ends.put(end, 0);
                            } else {
                                int count = (Integer)ends.get(end) + 1;
                                ends.put(end, count);
                                rec.setCount(count);
                            }
                        } else {
                            start = rec.getInterval().getStart();
                            end = rec.getInterval().getEnd();
                            ends.clear();
                            ends.put(end, 0);
                            rec.setCount(0);
                        }
                        if (!this.absorbGFFRecord(rec, result)) {
                            result.add(rec);
                        }
                    }
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException x) {
            LOG.info((Object)String.format("Reference \"%s\" not found.", ref));
        }
        return result;
    }

    @Override
    public void close() {
    }

    @Override
    public Set<String> getReferenceNames() {
        return this.reader.getReferenceNames();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public final DataFormat getDataFormat() {
        return this.mapping.format;
    }

    @Override
    public final String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public String[] getParticipants() {
        return this.extraColumns;
    }

    public boolean prefersAlternateName() {
        return this.mapping == ColumnMapping.REFSEQ;
    }

    private boolean absorbGFFRecord(TabixIntervalRecord rec, List<TabixIntervalRecord> recs) {
        if (rec instanceof GFFIntervalRecord) {
            if (((GFFIntervalRecord)rec).getFeatureType().equals("chromosome")) {
                return true;
            }
            GFFIntervalRecord child = (GFFIntervalRecord)rec;
            for (int i = recs.size() - 1; i >= 0; --i) {
                GFFIntervalRecord parent = (GFFIntervalRecord)recs.get(i);
                if (!parent.absorbRecord(child)) continue;
                return true;
            }
        }
        return false;
    }
}

