/*
 * Decompiled with CFR 0.152.
 */
package savant.data.types;

import java.util.LinkedHashMap;
import java.util.Map;
import savant.data.types.GFFIntervalRecord;
import savant.util.ColumnMapping;

public class GTFIntervalRecord
extends GFFIntervalRecord {
    GTFIntervalRecord(String line) {
        super(line, ColumnMapping.GTF);
        this.name = this.extractGTFAttribute("gene_id");
        this.name2 = this.extractGTFAttribute("transcript_id");
    }

    private String extractGTFAttribute(String key) {
        String attributes = this.values[8].trim();
        if (!attributes.startsWith(key)) {
            int semiPos = attributes.indexOf("; ");
            if (semiPos > 0) {
                attributes = attributes.substring(semiPos + 2);
            }
            if (!attributes.startsWith(key)) {
                return "";
            }
        }
        return attributes.substring(key.length() + 2, attributes.indexOf("\";"));
    }

    @Override
    public Map<String, String> getAttributes() {
        String[] attributes;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String s : attributes = this.values[8].trim().split("; ")) {
            int quotePos = s.indexOf(34);
            if (quotePos <= 0) continue;
            result.put(s.substring(0, quotePos).trim(), s.substring(quotePos + 1, s.indexOf(34, quotePos + 1)));
        }
        return result;
    }

    @Override
    protected boolean isParentOf(GFFIntervalRecord child) {
        return this.name.equals(child.name) && this.name2.equals(child.name2);
    }
}

