/*
 * Decompiled with CFR 0.152.
 */
package savant.data.types;

import savant.api.data.PointRecord;

public class GenericPointRecord
implements PointRecord {
    private final String reference;
    private final int point;
    private final String description;

    protected GenericPointRecord(String reference, int point, String description) {
        if (reference == null) {
            throw new IllegalArgumentException("reference must not be null");
        }
        this.reference = reference;
        this.point = point;
        this.description = description;
    }

    public static GenericPointRecord valueOf(String reference, int point, String description) {
        return new GenericPointRecord(reference, point, description);
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public int getPosition() {
        return this.point;
    }

    @Override
    public String getName() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericPointRecord that = (GenericPointRecord)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.point != that.point) {
            return false;
        }
        return this.reference.equals(that.reference);
    }

    public int hashCode() {
        int result = this.reference.hashCode();
        result = 31 * result + this.point;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GenericPointRecord");
        sb.append("{reference='").append(this.reference).append('\'');
        sb.append(", point=").append(this.point);
        sb.append(", description='").append(this.description).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public int compareTo(Object o) {
        GenericPointRecord that = (GenericPointRecord)o;
        if (!this.reference.equals(that.getReference())) {
            String a1 = this.reference;
            String a2 = that.getReference();
            for (int i = 0; i < Math.min(a1.length(), a2.length()); ++i) {
                if (a1.charAt(i) < a2.charAt(i)) {
                    return -1;
                }
                if (a1.charAt(i) <= a2.charAt(i)) continue;
                return 1;
            }
            if (a1.length() < a2.length()) {
                return -1;
            }
            if (a1.length() > a2.length()) {
                return 1;
            }
        }
        if (this.point == that.getPosition()) {
            return 0;
        }
        if (this.point < that.getPosition()) {
            return -1;
        }
        return 1;
    }
}

