/*
 * Decompiled with CFR 0.152.
 */
package savant.data.types;

import java.awt.Color;

public final class ItemRGB {
    private final int red;
    private final int blue;
    private final int green;

    public ItemRGB(int r, int g, int b) {
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public static ItemRGB valueOf(int r, int g, int b) {
        return new ItemRGB(r, g, b);
    }

    public static ItemRGB parseItemRGB(String token) {
        String[] values = token.split(",");
        if (values.length == 3) {
            try {
                return ItemRGB.valueOf(Integer.parseInt(values[0].trim()), Integer.parseInt(values[1].trim()), Integer.parseInt(values[2].trim()));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (token.equals("0")) {
            return ItemRGB.valueOf(0, 0, 0);
        }
        return ItemRGB.valueOf(-1, -1, -1);
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public boolean isNull() {
        return this.red < 0 || this.green < 0 || this.blue < 0;
    }

    public Color createColor() {
        return new Color(this.red, this.green, this.blue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemRGB itemRGB = (ItemRGB)o;
        if (this.blue != itemRGB.blue) {
            return false;
        }
        if (this.green != itemRGB.green) {
            return false;
        }
        return this.red == itemRGB.red;
    }

    public int hashCode() {
        int result = this.red;
        result = 31 * result + this.blue;
        result = 31 * result + this.green;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("red=").append(this.red);
        sb.append(", blue=").append(this.blue);
        sb.append(", green=").append(this.green);
        return sb.toString();
    }
}

