/*
 * Decompiled with CFR 0.152.
 */
package savant.data.types;

import savant.api.data.Record;
import savant.api.data.Strand;
import savant.api.data.VariantType;
import savant.util.Pileup;

public class PileupRecord
implements Record {
    public static final String[] NUCLEOTIDE_NAMES = new String[]{"A", "C", "G", "T", "Deletion", "Insertion", "Other"};
    int position;
    int[][] coverage;
    double[][] percentage;
    double[][] quality;

    public PileupRecord(Pileup p, boolean stranded) {
        this.position = p.getPosition();
        if (stranded) {
            this.coverage = new int[2][7];
            this.percentage = new double[2][7];
            this.quality = new double[2][7];
            double denominator0 = (double)p.getTotalCoverage(Strand.FORWARD) * 0.01;
            double denominator1 = (double)p.getTotalCoverage(Strand.REVERSE) * 0.01;
            int i = 0;
            for (VariantType nuc : VariantType.values()) {
                if (nuc == VariantType.NONE) continue;
                this.coverage[0][i] = p.getCoverage(nuc, Strand.FORWARD);
                this.percentage[0][i] = (double)this.coverage[0][i] / denominator0;
                this.quality[0][i] = p.getAverageQuality(nuc, Strand.FORWARD);
                this.coverage[1][i] = p.getCoverage(nuc, Strand.REVERSE);
                this.percentage[1][i] = (double)this.coverage[1][i] / denominator1;
                this.quality[1][i] = p.getAverageQuality(nuc, Strand.REVERSE);
                ++i;
            }
        } else {
            this.coverage = new int[1][7];
            this.percentage = new double[1][7];
            this.quality = new double[1][7];
            double denominator = (double)p.getTotalCoverage(null) * 0.01;
            int i = 0;
            for (VariantType nuc : VariantType.values()) {
                if (nuc == VariantType.NONE) continue;
                this.coverage[0][i] = p.getCoverage(nuc, null);
                this.percentage[0][i] = (double)this.coverage[0][i] / denominator;
                this.quality[0][i] = p.getAverageQuality(nuc, null);
                ++i;
            }
        }
    }

    public int compareTo(Object o) {
        PileupRecord that = (PileupRecord)o;
        if (this.getPosition() == that.getPosition()) {
            return 0;
        }
        if (this.getPosition() < that.getPosition()) {
            return -1;
        }
        return 1;
    }

    @Override
    public String getReference() {
        return null;
    }

    public int getPosition() {
        return this.position;
    }

    public int[] getCoverage(Strand strand) {
        return this.coverage[strand == Strand.REVERSE ? 1 : 0];
    }

    public double[] getPercentage(Strand strand) {
        return this.percentage[strand == Strand.REVERSE ? 1 : 0];
    }

    public double[] getAverageQuality(Strand strand) {
        return this.quality[strand == Strand.REVERSE ? 1 : 0];
    }
}

