/*
 * Decompiled with CFR 0.152.
 */
package savant.file;

import savant.api.data.DataFormat;

public enum FileType {
    INTERVAL_BAM(-87114239),
    INTERVAL_GENERIC(-87114237),
    INTERVAL_BED(-87114236),
    INTERVAL_GFF(-87114235),
    CONTINUOUS_WIG(-87114234),
    CONTINUOUS_GENERIC(-87114233),
    SEQUENCE_FASTA(-87114232),
    POINT_GENERIC(-87114231),
    TABIX(-1),
    INTERVAL_BIGBED(-1),
    CONTINUOUS_BIGWIG(-1),
    CONTINUOUS_TDF(-1),
    INTERVAL_BED1(-1),
    INTERVAL_PSL(-1),
    INTERVAL_VCF(-1),
    INTERVAL_KNOWNGENE(-1),
    INTERVAL_REFGENE(-1),
    INTERVAL_UNKNOWN(-1),
    INTERVAL_GTF(-1);

    int magicNumber;

    private FileType(int magicNumber) {
        this.magicNumber = magicNumber;
    }

    public int getMagicNumber() {
        return this.magicNumber;
    }

    public DataFormat toDataFormat() {
        switch (this) {
            case INTERVAL_BAM: {
                return DataFormat.ALIGNMENT;
            }
            case INTERVAL_GENERIC: {
                return DataFormat.GENERIC_INTERVAL;
            }
            case INTERVAL_BED: 
            case INTERVAL_GFF: 
            case INTERVAL_GTF: 
            case TABIX: 
            case INTERVAL_BIGBED: 
            case INTERVAL_BED1: 
            case INTERVAL_KNOWNGENE: 
            case INTERVAL_REFGENE: 
            case INTERVAL_UNKNOWN: {
                return DataFormat.RICH_INTERVAL;
            }
            case INTERVAL_PSL: {
                return DataFormat.RICH_INTERVAL;
            }
            case CONTINUOUS_WIG: 
            case CONTINUOUS_GENERIC: 
            case CONTINUOUS_BIGWIG: 
            case CONTINUOUS_TDF: {
                return DataFormat.CONTINUOUS;
            }
            case SEQUENCE_FASTA: {
                return DataFormat.SEQUENCE;
            }
            case POINT_GENERIC: {
                return DataFormat.POINT;
            }
            case INTERVAL_VCF: {
                return DataFormat.VARIANT;
            }
        }
        return null;
    }

    public static FileType fromMagicNumber(int magicNumber) {
        FileType[] types = FileType.values();
        for (int i = 0; i < types.length; ++i) {
            if (types[i].getMagicNumber() != magicNumber) continue;
            return types[i];
        }
        return null;
    }
}

