/*
 * Decompiled with CFR 0.152.
 */
package savant.format;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tools.PreprocessingException;
import org.broad.igv.tools.Preprocessor;
import savant.format.TDFFormatter;
import savant.util.MiscUtils;

public class BAMToCoverage
extends TDFFormatter {
    private static final int DEFAULT_WINDOW_SIZE = 25;
    private static final int DEFAULT_EXT_FACTOR = 0;
    private static final int DEFAULT_STRAND_OPTION = -1;

    public BAMToCoverage(File inFile) {
        super(inFile, new File(inFile.getAbsolutePath() + ".cov.tdf"));
    }

    @Override
    public void format() throws InterruptedException, IOException {
        Genome genome = this.getTDFGenome();
        this.setProgress(0.2, "Generating TDF file...");
        Preprocessor pp = new Preprocessor(this.outFile, genome, MEAN, 1000000, new TDFFormatter.TDFProgressMonitor(this));
        try {
            pp.count(this.inFile.getAbsolutePath(), 25, 0, 9, null, null, null);
            pp.finish();
        }
        catch (PreprocessingException x) {
            throw new IOException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LinkedHashMap<String, Integer> inferChromosomes() throws InterruptedException, IOException {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        this.inFileReader = this.openInputFile();
        this.setProgress(0.0, "Processing input file...");
        SAMFileReader samFileReader = new SAMFileReader(this.inFile, this.determineIndexFile());
        try {
            SAMFileHeader fileHeader = samFileReader.getFileHeader();
            SAMSequenceDictionary dictionary = fileHeader.getSequenceDictionary();
            List sequences = dictionary.getSequences();
            for (SAMSequenceRecord sequence : sequences) {
                result.put(MiscUtils.homogenizeSequence(sequence.getSequenceName()), sequence.getSequenceLength());
            }
        }
        finally {
            if (samFileReader != null) {
                samFileReader.close();
            }
        }
        return result;
    }

    private File determineIndexFile() throws IOException {
        String path = this.inFile.getAbsolutePath();
        int lastIndex = path.lastIndexOf(".bam");
        if (lastIndex == -1) {
            throw new IOException("BAM files should end with the \".bam\" file extension.");
        }
        String pathWithoutExtension = path.substring(0, lastIndex);
        File f = new File(path + ".bai");
        if (f.exists()) {
            return f;
        }
        f = new File(pathWithoutExtension + ".bai");
        if (f.exists()) {
            return f;
        }
        throw new FileNotFoundException("Unable to find index file for " + this.inFile + ".");
    }
}

