/*
 * Decompiled with CFR 0.152.
 */
package savant.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import savant.api.data.IntervalRecord;
import savant.api.util.RangeUtils;
import savant.file.SavantROFile;
import savant.format.IntervalTreeNode;
import savant.format.SavantFileFormatterUtils;
import savant.util.IntervalRecordComparator;
import savant.util.Range;
import savant.util.SavantFileUtils;

public class IntervalRecordGetter {
    public static List<IntervalRecord> getData(SavantROFile dFile, String reference, Range r, IntervalTreeNode n) throws IOException {
        ArrayList<IntervalRecord> result = new ArrayList<IntervalRecord>();
        IntervalRecordGetter.getData(dFile, result, reference, r, n);
        Collections.sort(result, new IntervalRecordComparator());
        return result;
    }

    private static void getData(SavantROFile dFile, List<IntervalRecord> data, String reference, Range r, IntervalTreeNode n) throws IOException {
        if (RangeUtils.intersects(r, n.range)) {
            data.addAll(IntervalRecordGetter.getIntersectingIntervals(dFile, reference, r, n));
            for (IntervalTreeNode child : n.children) {
                if (child == null || child.subtreeSize <= 0 || !RangeUtils.intersects(child.range, r)) continue;
                IntervalRecordGetter.getData(dFile, data, reference, r, child);
            }
        }
    }

    private static List<IntervalRecord> getIntersectingIntervals(SavantROFile dFile, String reference, Range r, IntervalTreeNode n) throws IOException {
        ArrayList<IntervalRecord> data = new ArrayList<IntervalRecord>();
        if (n.size > 0) {
            dFile.seek(reference, n.startByte);
            for (int i = 0; i < n.size; ++i) {
                List<Object> record = SavantFileUtils.readBinaryRecord(dFile, dFile.getFields());
                IntervalRecord ir = SavantFileFormatterUtils.convertRecordToInterval(record, dFile.getFileType(), dFile.getFields());
                if (!ir.getInterval().intersectsRange(r)) continue;
                data.add(ir);
            }
        }
        return data;
    }

    public static List<IntervalRecord> getRecordsInBin(SavantROFile dFile, String reference, IntervalTreeNode n) throws IOException {
        ArrayList<IntervalRecord> recs = new ArrayList<IntervalRecord>(n.size);
        if (n.size > 0) {
            dFile.seek(reference, n.startByte);
            for (int i = 0; i < n.size; ++i) {
                List<Object> record = SavantFileUtils.readBinaryRecord(dFile, dFile.getFields());
                IntervalRecord ir = SavantFileFormatterUtils.convertRecordToInterval(record, dFile.getFileType(), dFile.getFields());
                recs.add(ir);
            }
        }
        return recs;
    }
}

