/*
 * Decompiled with CFR 0.152.
 */
package savant.format;

import com.jidesoft.dialog.JideOptionPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.util.DialogUtils;
import savant.file.FieldType;
import savant.file.FileType;
import savant.file.SavantROFile;
import savant.format.BAMToCoverage;
import savant.format.FormatEvent;
import savant.format.IntervalSearchTree;
import savant.format.IntervalTreeNode;
import savant.format.SavantFileFormattingException;
import savant.format.TDFFormatter;
import savant.format.TabixFormatter;
import savant.util.Controller;
import savant.util.DownloadEvent;
import savant.util.MiscUtils;
import savant.util.Range;
import savant.util.SavantFileUtils;
import savant.util.error.report.BugReportDialog;
import savant.view.swing.Savant;

public abstract class SavantFileFormatter
extends Controller<FormatEvent> {
    static final Log LOG = LogFactory.getLog(SavantFileFormatter.class);
    protected final File inFile;
    protected final File outFile;
    protected BufferedReader inFileReader;
    private Thread formatThread;
    protected long totalBytes;
    protected long byteCount;

    public SavantFileFormatter(File inFile, File outFile) {
        this.inFile = inFile;
        this.outFile = outFile;
    }

    public File getInputFile() {
        return this.inFile;
    }

    public File getOutputFile() {
        return this.outFile;
    }

    public abstract void format() throws InterruptedException, IOException;

    protected void setProgress(double prog, String status) {
        this.fireEvent(new FormatEvent(prog, status));
    }

    protected BufferedReader openInputFile() throws FileNotFoundException {
        return new BufferedReader(new FileReader(this.inFile));
    }

    public static SavantFileFormatter getFormatter(File inFile, File outFile, FileType inputFileType) throws IOException, SavantFileFormattingException {
        if (inputFileType == FileType.INTERVAL_BAM) {
            return new BAMToCoverage(inFile);
        }
        switch (inputFileType) {
            case INTERVAL_BED: 
            case INTERVAL_BED1: 
            case INTERVAL_GENERIC: 
            case INTERVAL_GFF: 
            case INTERVAL_GTF: 
            case INTERVAL_PSL: 
            case INTERVAL_VCF: 
            case INTERVAL_KNOWNGENE: 
            case INTERVAL_REFGENE: 
            case INTERVAL_UNKNOWN: {
                if (!SavantFileFormatter.verifyTextFile(inFile, '#', true)) {
                    if (DialogUtils.askYesNo("<html>This file does not appear to be tab-delimited. Do you wish to try processing this file by interpreting runs of spaces as tabs?<br><br><i>Warning: This may or may not work correctly.</i></html>") == 0) {
                        return new TabixFormatter(inFile, outFile, inputFileType, true);
                    }
                    return null;
                }
                return new TabixFormatter(inFile, outFile, inputFileType, false);
            }
            case CONTINUOUS_WIG: {
                SavantFileFormatter.verifyTextFile(inFile, '#', false);
                return new TDFFormatter(inFile, outFile);
            }
        }
        return null;
    }

    public void run() {
        this.formatThread = new Thread("Formatter"){

            @Override
            public void run() {
                try {
                    SavantFileFormatter.this.fireEvent(new FormatEvent(DownloadEvent.Type.STARTED));
                    SavantFileFormatter.this.format();
                    SavantFileFormatter.this.fireEvent(new FormatEvent(SavantFileFormatter.this.outFile));
                }
                catch (Throwable x) {
                    LOG.info((Object)"Formatting failed.", x.getCause());
                    SavantFileFormatter.this.fireEvent(new FormatEvent(x));
                }
            }
        };
        this.formatThread.start();
    }

    public void cancel() {
        this.formatThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyTextFile(File f, char commentChar, boolean lookingForTabs) throws IOException, SavantFileFormattingException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(f));
            String line = reader.readLine();
            while ((line = reader.readLine()) != null && line.charAt(0) == commentChar) {
            }
            boolean tabFound = false;
            if (line != null) {
                for (int i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (c == '\t') {
                        tabFound = true;
                        continue;
                    }
                    if (c >= ' ' && c <= '~') continue;
                    throw new SavantFileFormattingException(String.format("%s does not appear to be a text file.", f.getName()));
                }
            }
            if (lookingForTabs && !tabFound) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
        return true;
    }

    public static void reportFormattingError(Throwable x, final File inFile) {
        if (x instanceof InterruptedException) {
            DialogUtils.displayMessage("Format cancelled.");
        } else if (x instanceof SavantFileFormattingException) {
            DialogUtils.displayMessage("Format Unsuccessful", x.getMessage());
        } else {
            JideOptionPane optionPane = new JideOptionPane((Object)String.format("<html>Message: <i>%s</i><br><br>Click the <i>Details</i> button to see more information...<br><br>Please report any issues you experience to the to the development team.</html>", MiscUtils.getMessage(x)), 0, 3);
            optionPane.setTitle((Object)"A problem was encountered while formatting.");
            optionPane.setOptions((Object[])new String[0]);
            JButton reportButton = new JButton("Report Issue");
            ((JComponent)optionPane.getComponent(optionPane.getComponentCount() - 1)).add(reportButton);
            final JDialog dialog = optionPane.createDialog((Component)DialogUtils.getMainWindow(), "Format Unsuccessful");
            dialog.setModal(true);
            dialog.setResizable(true);
            optionPane.setDetails((Object)MiscUtils.getStackTrace(x));
            dialog.pack();
            reportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    String issue = "I am having trouble formatting my file for use with Savant.\nI have provided additional diagnostic information below.\n\n";
                    issue = issue + "SOURCE OF FILE: [e.g. UCSC]\n\n";
                    issue = issue + "TYPE: [e.g. BED]\n\n";
                    issue = issue + "CONTENTS: [e.g. human genes]\n\n";
                    issue = issue + "PATH: " + inFile + "\n\n";
                    issue = issue + "ADDITIONAL COMMENTS:\n\n";
                    dialog.dispose();
                    new BugReportDialog((Frame)Savant.getInstance(), issue).setVisible(true);
                }
            });
            dialog.setVisible(true);
        }
    }

    public static Map<String, IntervalSearchTree> readIntervalBSTs(SavantROFile dFile) throws IOException {
        Map<String, long[]> refMap = SavantFileUtils.readReferenceMap(dFile);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"\n=== DONE PARSING REF<->DATA MAP ===\n\n");
        }
        dFile.setHeaderOffset(dFile.getFilePointer());
        HashMap<String, IntervalSearchTree> trees = new HashMap<String, IntervalSearchTree>();
        int treenum = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Number of trees to get: " + refMap.keySet().size()));
        }
        long maxend = Long.MIN_VALUE;
        for (String refname : refMap.keySet()) {
            long[] v = refMap.get(refname);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("========== Reading tree for reference " + refname + " =========="));
            }
            dFile.seek(v[0] + dFile.getHeaderOffset());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Starting tree at: " + dFile.getFilePointer()));
            }
            IntervalSearchTree t = SavantFileFormatter.readIntervalBST(dFile);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Finished tree at: " + dFile.getFilePointer()));
            }
            maxend = Math.max(maxend, dFile.getFilePointer());
            trees.put(refname, t);
            ++treenum;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Read " + treenum + " trees (i.e. indices)"));
            LOG.debug((Object)"\n=== DONE PARSING REF<->INDEX MAP ===");
            LOG.debug((Object)("Changing offset from " + dFile.getHeaderOffset() + " to " + (dFile.getFilePointer() + dFile.getHeaderOffset()) + "\n"));
        }
        dFile.setHeaderOffset(maxend);
        return trees;
    }

    private static IntervalSearchTree readIntervalBST(SavantROFile file) throws IOException {
        ArrayList<IntervalTreeNode> nodes = new ArrayList<IntervalTreeNode>();
        ArrayList<FieldType> fields = new ArrayList<FieldType>();
        fields.add(FieldType.INTEGER);
        fields.add(FieldType.RANGE);
        fields.add(FieldType.LONG);
        fields.add(FieldType.INTEGER);
        fields.add(FieldType.INTEGER);
        fields.add(FieldType.INTEGER);
        HashMap<Integer, Integer> nodeIndex2ParentIndices = new HashMap<Integer, Integer>();
        int i = 0;
        while (true) {
            List<Object> r1;
            LOG.debug((Object)("Reading node at byte position: " + file.getFilePointer()));
            try {
                r1 = SavantFileUtils.readBinaryRecord(file, fields);
            }
            catch (EOFException e) {
                LOG.error((Object)"Hit EOF while trying to parse IntervalSearchTree from file");
                break;
            }
            IntervalTreeNode n = new IntervalTreeNode((Range)r1.get(1), (Integer)r1.get(0));
            if (n.index == -1) {
                LOG.debug((Object)("Tree contains " + i + " nodes"));
                break;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Node params read: ");
                for (int j = 0; j < 6; ++j) {
                    LOG.debug((Object)(j + ". " + r1.get(j)));
                }
            }
            n.startByte = (Long)r1.get(2);
            n.size = (Integer)r1.get(3);
            n.subtreeSize = (Integer)r1.get(4);
            nodeIndex2ParentIndices.put(n.index, (Integer)r1.get(5));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Node:\tindex: " + n.index + "\trange: " + n.range + "\tsize: " + n.size + "\tsubsize: " + n.subtreeSize + "\tbyte: " + n.startByte));
            }
            nodes.add(n);
            LOG.debug((Object)(++i + ". Read node with range " + n.range + " and index " + n.index));
        }
        Collections.sort(nodes);
        LOG.debug((Object)"Finished parsing IBST");
        HashMap<Integer, List> nodeIndex2ChildIndices = new HashMap<Integer, List>();
        for (Integer key : nodeIndex2ParentIndices.keySet()) {
            int parent = (Integer)nodeIndex2ParentIndices.get(key);
            if (!nodeIndex2ChildIndices.containsKey(parent)) {
                nodeIndex2ChildIndices.put(parent, new ArrayList());
            }
            List children = (List)nodeIndex2ChildIndices.get(parent);
            children.add(key);
            nodeIndex2ChildIndices.put(parent, children);
        }
        for (Integer index : nodeIndex2ChildIndices.keySet()) {
            if (index == -1) continue;
            IntervalTreeNode n = (IntervalTreeNode)nodes.get(index);
            List cis = (List)nodeIndex2ChildIndices.get(index);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Node " + n.index + " [ "));
            }
            for (Integer childIndex : cis) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(childIndex + " "));
                }
                n.children.add((IntervalTreeNode)nodes.get(childIndex));
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)"]");
        }
        return new IntervalSearchTree(nodes);
    }
}

