/*
 * Decompiled with CFR 0.152.
 */
package savant.format;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import savant.api.data.Block;
import savant.api.data.Interval;
import savant.api.data.IntervalRecord;
import savant.api.data.Strand;
import savant.api.util.DialogUtils;
import savant.data.types.BEDIntervalRecord;
import savant.data.types.GenericIntervalRecord;
import savant.data.types.ItemRGB;
import savant.file.FieldType;
import savant.file.FileType;
import savant.util.MiscUtils;
import savant.util.NetworkUtils;
import savant.util.Range;
import savant.view.dialog.DataFormatForm;

public class SavantFileFormatterUtils {
    public static final int LONG_FIELD_SIZE = 8;
    public static final int INT_FIELD_SIZE = 4;
    public static final int SHORT_FIELD_SIZE = 2;
    public static final int CHAR_FIELD_SIZE = 2;
    public static final int BYTE_FIELD_SIZE = 1;
    public static final int BOOLEAN_FIELD_SIZE = 1;
    public static final int DOUBLE_FIELD_SIZE = 8;
    public static final int FLOAT_FIELD_SIZE = 4;

    public static FileType guessFileTypeFromPath(String path) {
        String extension = MiscUtils.getExtension(path).toLowerCase();
        if (extension.equals("bam")) {
            return FileType.INTERVAL_BAM;
        }
        if (extension.equals("bed")) {
            return FileType.INTERVAL_BED;
        }
        if (extension.equals("gff")) {
            return FileType.INTERVAL_GFF;
        }
        if (extension.equals("gtf")) {
            return FileType.INTERVAL_GTF;
        }
        if (extension.equals("wig") || extension.equals("bedgraph")) {
            return FileType.CONTINUOUS_WIG;
        }
        if (extension.equals("fa") || extension.equals("fasta")) {
            return FileType.SEQUENCE_FASTA;
        }
        if (extension.equals("gz")) {
            return FileType.TABIX;
        }
        if (extension.equals("bw") || extension.equals("bigwig")) {
            return FileType.CONTINUOUS_BIGWIG;
        }
        if (extension.equals("bb") || extension.equals("bigbed")) {
            return FileType.INTERVAL_BIGBED;
        }
        if (extension.equals("tdf")) {
            return FileType.CONTINUOUS_TDF;
        }
        if (extension.equals("psl")) {
            return FileType.INTERVAL_PSL;
        }
        if (extension.equals("vcf")) {
            return FileType.INTERVAL_VCF;
        }
        if (extension.equals("gene") || extension.equals("knowngene")) {
            return FileType.INTERVAL_KNOWNGENE;
        }
        if (extension.equals("refgene")) {
            return FileType.INTERVAL_REFGENE;
        }
        return null;
    }

    public static File getFormattedFile(String inputPath, FileType ft) {
        String outputPath = inputPath;
        switch (ft) {
            case CONTINUOUS_WIG: {
                outputPath = outputPath + ".tdf";
                break;
            }
            case INTERVAL_BED: 
            case INTERVAL_BED1: 
            case INTERVAL_GENERIC: 
            case INTERVAL_GFF: 
            case INTERVAL_GTF: 
            case INTERVAL_PSL: 
            case INTERVAL_VCF: 
            case INTERVAL_KNOWNGENE: 
            case INTERVAL_REFGENE: {
                outputPath = outputPath + ".gz";
                break;
            }
        }
        return new File(outputPath);
    }

    public static List<Object> readBinaryRecord(RandomAccessFile in, List<FieldType> fields) throws IOException {
        ArrayList<Object> record = new ArrayList<Object>(fields.size());
        for (FieldType ft : fields) {
            if (ft == FieldType.IGNORE) continue;
            switch (ft) {
                case INTEGER: {
                    record.add(in.readInt());
                    break;
                }
                case ITEMRGB: {
                    int r = in.readInt();
                    int g = in.readInt();
                    int b = in.readInt();
                    record.add(ItemRGB.valueOf(r, g, b));
                    break;
                }
                case DOUBLE: {
                    record.add(in.readDouble());
                    break;
                }
                case FLOAT: {
                    record.add(Float.valueOf(in.readFloat()));
                    break;
                }
                case BLOCKS: {
                    int numBlocks = in.readInt();
                    ArrayList<Block> blocks = new ArrayList<Block>(numBlocks);
                    for (int i = 0; i < numBlocks; ++i) {
                        int start = in.readInt();
                        int size = in.readInt();
                        blocks.add(Block.valueOf(start, size));
                    }
                    record.add(blocks);
                    break;
                }
                case STRING: {
                    int len = in.readInt();
                    if (len > 10000) {
                        throw new IOException("Tried to read binary string of length " + len + " characters");
                    }
                    String s = "";
                    for (int i = 0; i < len; ++i) {
                        s = s + (char)in.readByte();
                    }
                    record.add(s);
                    break;
                }
                case CHAR: {
                    record.add(Character.valueOf((char)in.readByte()));
                    break;
                }
                case RANGE: {
                    int start = in.readInt();
                    int end = in.readInt();
                    record.add(new Range(start, end));
                    break;
                }
                case LONG: {
                    record.add(in.readLong());
                    break;
                }
                case IGNORE: {
                    break;
                }
            }
        }
        return record;
    }

    public static int getRecordSize(List<Object> record, List<FieldType> fields) {
        int recordSize = 0;
        int recIndex = 0;
        for (FieldType ft : fields) {
            if (ft == FieldType.IGNORE) continue;
            switch (ft) {
                case STRING: {
                    recordSize += 4 + ((String)record.get(recIndex)).length() * 1;
                    break;
                }
                case INTEGER: {
                    recordSize += 4;
                    break;
                }
                case ITEMRGB: {
                    recordSize += 12;
                    break;
                }
                case BLOCKS: {
                    recordSize += 4 * ((List)record.get(9)).size();
                    break;
                }
                case CHAR: {
                    ++recordSize;
                    break;
                }
                case DOUBLE: {
                    recordSize += 8;
                    break;
                }
                case FLOAT: {
                    recordSize += 4;
                    break;
                }
                case BOOLEAN: {
                    recordSize += 4;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Data Utils.getRecordSize: Not implemented yet!");
                }
            }
            ++recIndex;
        }
        return recordSize;
    }

    public static IntervalRecord convertRecordToInterval(List<Object> record, FileType fileType, List<FieldType> fields) {
        IntervalRecord ir = null;
        switch (fileType) {
            case INTERVAL_GENERIC: {
                ir = SavantFileFormatterUtils.convertRecordToGenericInterval(record, fields);
                break;
            }
            case INTERVAL_BED: {
                ir = SavantFileFormatterUtils.convertRecordToBEDInterval(record, fields);
                break;
            }
            case INTERVAL_GFF: {
                ir = SavantFileFormatterUtils.convertRecordToGenericInterval(record, fields);
                break;
            }
        }
        return ir;
    }

    private static IntervalRecord convertRecordToGenericInterval(List<Object> record, List<FieldType> fields) {
        GenericIntervalRecord ir = record.size() > 3 ? GenericIntervalRecord.valueOf((String)record.get(0), Interval.valueOf((Integer)record.get(1), (Integer)record.get(2)), (String)record.get(3)) : GenericIntervalRecord.valueOf((String)record.get(0), Interval.valueOf((Integer)record.get(1), (Integer)record.get(2)), "");
        return ir;
    }

    private static IntervalRecord convertRecordToBEDInterval(List<Object> record, List<FieldType> fields) {
        int start = (Integer)record.get(1);
        int end = (Integer)record.get(2);
        String ref = (String)record.get(0);
        int numFields = record.size();
        String name = "";
        Float score = Float.valueOf(0.0f);
        Strand strand = SavantFileFormatterUtils.getStrand("+");
        int thickStart = 0;
        int thickEnd = 0;
        ItemRGB rgb = ItemRGB.valueOf(-1, -1, -1);
        List<Block> blocks = null;
        if (numFields > 3) {
            name = (String)record.get(3);
        }
        if (numFields > 4) {
            Object o = record.get(4);
            if (o instanceof Integer) {
                score = Float.valueOf(((Integer)o).floatValue());
            } else if (o instanceof Float) {
                score = (Float)record.get(4);
            }
        }
        int intervallength = Interval.valueOf(start, end).getLength();
        if (numFields > 5) {
            strand = SavantFileFormatterUtils.getStrand((String)record.get(5));
        }
        if (numFields > 6) {
            thickStart = (Integer)record.get(6);
        }
        thickEnd = numFields > 7 ? (Integer)record.get(7) : intervallength;
        if (numFields > 8) {
            rgb = (ItemRGB)record.get(8);
        }
        if (numFields > 9) {
            blocks = (List)record.get(9);
        } else {
            blocks = new ArrayList();
            blocks.add(Block.valueOf(0, intervallength));
        }
        BEDIntervalRecord ir = BEDIntervalRecord.valueOf(ref, start, end, name, score.floatValue(), strand, thickStart, thickEnd, rgb, blocks);
        return ir;
    }

    public static Strand getStrand(String strand) {
        char c = strand.charAt(0);
        if (c == '-') {
            return Strand.REVERSE;
        }
        return Strand.FORWARD;
    }

    public static void promptUserToFormatFile(URI uri) {
        if (DialogUtils.askYesNo("Unformatted File", String.format("<html><i>%s</i> does not appear to be formatted. Format now?</html>", NetworkUtils.getFileName(uri))) == 0) {
            new DataFormatForm(DialogUtils.getMainWindow(), uri, true).setVisible(true);
        }
    }
}

