/*
 * Decompiled with CFR 0.152.
 */
package savant.plugin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.commons.lang3.StringUtils;
import savant.api.adapter.BAMDataSourceAdapter;
import savant.api.adapter.TrackAdapter;
import savant.api.data.DataFormat;
import savant.api.event.LocationChangedEvent;
import savant.api.event.TrackEvent;
import savant.api.util.Listener;
import savant.api.util.TrackUtils;
import savant.controller.LocationController;
import savant.plugin.Tool;
import savant.plugin.ToolArgument;
import savant.util.NetworkUtils;

class ToolSettingsPanel
extends JPanel
implements Scrollable {
    private final Tool tool;
    private JLabel commandLine;
    private ActionListener executeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            ToolSettingsPanel.this.tool.execute();
        }
    };

    ToolSettingsPanel(Tool t) {
        this.tool = t;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.gridy = 0;
        try {
            this.tool.parseDescriptor();
            this.commandLine = new JLabel("", 0);
            this.commandLine.setFont(new Font("Serif", 0, 14));
            this.commandLine.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            gbc.insets = new Insets(10, 10, 10, 10);
            gbc.fill = 2;
            this.add((Component)this.commandLine, gbc);
            JButton executeButton = new JButton("Execute");
            executeButton.addActionListener(this.executeListener);
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.gridy = 1;
            gbc.fill = 0;
            this.add((Component)executeButton, gbc);
            for (ToolArgument a : this.tool.arguments) {
                this.addArgumentToPanel(a, ++gbc.gridy);
            }
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            this.add((Component)new JPanel(), gbc);
            this.tool.displayCommandLine(this.commandLine);
        }
        catch (Exception x) {
            Tool.LOG.info((Object)String.format("Unable to load %s.", this.tool.getDescriptor().getFile()), (Throwable)x);
            this.add((Component)new JLabel(String.format("<html>Unable to load <i>%s</i><br>%s</html>", this.tool.getDescriptor().getFile(), x)), gbc);
        }
    }

    private void addArgumentToPanel(ToolArgument arg, int row) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridy = row;
        Object widget = null;
        if (arg.type == ToolArgument.Type.BOOL) {
            gbc.gridx = 2;
            gbc.anchor = 17;
            this.addWidget(arg, new BoolCheck(arg), gbc);
        } else {
            gbc.gridx = 1;
            gbc.anchor = 13;
            JLabel nameLabel = new JLabel(arg.name + ":");
            this.add((Component)nameLabel, gbc);
            gbc.gridx = 2;
            gbc.anchor = 17;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            JTextField field = null;
            switch (arg.type) {
                case INT: {
                    field = new JFormattedTextField();
                    ((JFormattedTextField)field).setValue(Integer.valueOf(arg.value != null ? arg.value : "0"));
                    field.setColumns(5);
                    this.addField(arg, field, gbc);
                    break;
                }
                case FLOAT: {
                    field = new JFormattedTextField();
                    ((JFormattedTextField)field).setValue(Double.valueOf(arg.value != null ? arg.value : "0.0"));
                    field.setColumns(10);
                    this.addField(arg, field, gbc);
                    break;
                }
                case OUTPUT_FILE: {
                    gbc.gridwidth = 1;
                    gbc.fill = 2;
                    field = new JTextField(arg.value);
                    this.addField(arg, field, gbc);
                    gbc.gridx = 3;
                    gbc.gridwidth = 0;
                    gbc.weightx = 0.0;
                    JCheckBox loadCheck = new JCheckBox("Load upon Completion", true);
                    loadCheck.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            ((ToolSettingsPanel)ToolSettingsPanel.this).tool.loadUponCompletion = ((JCheckBox)ae.getSource()).isSelected();
                        }
                    });
                    this.add((Component)loadCheck, gbc);
                    break;
                }
                case RANGE: {
                    field = new JTextField();
                    field.setColumns(25);
                    LocationController.getInstance().addListener(new RangeUpdater(field));
                    this.addField(arg, field, gbc);
                    break;
                }
                case LIST: {
                    this.addWidget(arg, new StringCombo(arg), gbc);
                    break;
                }
                case MULTI: {
                    gbc.fill = 2;
                    this.addWidget(arg, new MultiCheckGrid(arg), gbc);
                    break;
                }
                case BAM_INPUT_FILE: {
                    TrackUtils.addTrackListener((TrackCombo)this.addWidget(arg, new TrackCombo(arg, DataFormat.ALIGNMENT), gbc));
                    break;
                }
                case FASTA_INPUT_FILE: {
                    TrackUtils.addTrackListener((TrackCombo)this.addWidget(arg, new TrackCombo(arg, DataFormat.SEQUENCE), gbc));
                }
            }
        }
    }

    private void addField(ToolArgument arg, JTextField field, GridBagConstraints gbc) {
        field.addActionListener(this.executeListener);
        field.getDocument().addDocumentListener(new EditListener(arg));
        field.setMinimumSize(field.getPreferredSize());
        this.addWidget(arg, field, gbc);
    }

    private JComponent addWidget(ToolArgument arg, JComponent widget, GridBagConstraints gbc) {
        JCheckBox enablerCheck = null;
        if (!arg.required) {
            enablerCheck = new JCheckBox();
            GridBagConstraints gbc2 = new GridBagConstraints();
            gbc2.insets = new Insets(5, 5, 5, 5);
            gbc2.gridy = gbc.gridy;
            gbc2.gridx = 0;
            this.add((Component)enablerCheck, gbc2);
        }
        this.add((Component)widget, gbc);
        if (enablerCheck != null) {
            enablerCheck.addActionListener(new EnablerCheckListener(arg, widget));
        }
        return widget;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rctngl, int i, int i1) {
        return 1;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rctngl, int i, int i1) {
        return 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private class EditListener
    implements DocumentListener {
        ToolArgument argument;

        private EditListener(ToolArgument arg) {
            this.argument = arg;
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            try {
                Document d = de.getDocument();
                this.argument.value = d.getText(0, d.getLength());
                ToolSettingsPanel.this.tool.displayCommandLine(ToolSettingsPanel.this.commandLine);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            try {
                Document d = de.getDocument();
                this.argument.value = d.getText(0, d.getLength());
                ToolSettingsPanel.this.tool.displayCommandLine(ToolSettingsPanel.this.commandLine);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
            try {
                Document d = de.getDocument();
                this.argument.value = d.getText(0, d.getLength());
                ToolSettingsPanel.this.tool.displayCommandLine(ToolSettingsPanel.this.commandLine);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private class RangeUpdater
    implements Listener<LocationChangedEvent> {
        private final JTextField field;

        RangeUpdater(JTextField f) {
            this.field = f;
        }

        @Override
        public void handleEvent(LocationChangedEvent event) {
            this.field.setText(String.format("%s:%d-%d", event.getReference(), event.getRange().getFrom(), event.getRange().getTo()));
        }
    }

    private class StringCombo
    extends JComboBox {
        private final ToolArgument argument;

        private StringCombo(ToolArgument arg) {
            super(arg.choices);
            this.argument = arg;
            super.setSelectedItem(arg.value);
        }

        @Override
        public void setSelectedItem(Object o) {
            super.setSelectedItem(o);
            this.argument.value = (String)o;
            ToolSettingsPanel.this.tool.displayCommandLine(ToolSettingsPanel.this.commandLine);
        }
    }

    private class MultiCheckGrid
    extends JPanel {
        private final ToolArgument argument;
        private final ActionListener checkListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ArrayList<String> checks = new ArrayList<String>();
                for (Component c : MultiCheckGrid.this.getComponents()) {
                    JCheckBox cb = (JCheckBox)c;
                    if (!cb.isSelected()) continue;
                    checks.add(cb.getText());
                }
                ((MultiCheckGrid)MultiCheckGrid.this).argument.value = StringUtils.join(checks, (char)',');
                ToolSettingsPanel.this.tool.displayCommandLine(ToolSettingsPanel.this.commandLine);
            }
        };
        int widestCheck;

        private MultiCheckGrid(ToolArgument arg) {
            this.argument = arg;
            this.setLayout(new GridLayout(0, 1, 5, 5));
            this.widestCheck = 1;
            Font f = this.getFont();
            Font smallFont = f.deriveFont((float)f.getSize() - 2.0f);
            for (String t : arg.choices) {
                JCheckBox check = new JCheckBox(t);
                check.setFont(smallFont);
                check.addActionListener(this.checkListener);
                this.add(check);
                this.widestCheck = Math.max(this.widestCheck, check.getPreferredSize().width);
            }
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int oldCols = ((GridLayout)MultiCheckGrid.this.getLayout()).getColumns();
                    int newCols = Math.min(MultiCheckGrid.this.getComponentCount(), MultiCheckGrid.this.getWidth() / MultiCheckGrid.this.widestCheck);
                    if (newCols != oldCols) {
                        Tool.LOG.info((Object)("New width for " + ((MultiCheckGrid)MultiCheckGrid.this).argument.name + " was " + MultiCheckGrid.this.getWidth() + ", setting columns to " + newCols));
                        ((GridLayout)MultiCheckGrid.this.getLayout()).setColumns(newCols);
                        MultiCheckGrid.this.revalidate();
                    }
                }
            });
        }

        @Override
        public void setEnabled(boolean flag) {
            for (Component c : this.getComponents()) {
                c.setEnabled(flag);
            }
        }
    }

    private class TrackCombo
    extends JComboBox
    implements Listener<TrackEvent> {
        private final ToolArgument argument;
        private final DataFormat format;
        private String selection;

        TrackCombo(ToolArgument arg, DataFormat df) {
            this.argument = arg;
            this.format = df;
            this.handleEvent((TrackEvent)null);
        }

        @Override
        public final void handleEvent(TrackEvent event) {
            ArrayList<String> tracks = new ArrayList<String>();
            for (TrackAdapter t : TrackUtils.getTracks(this.format)) {
                tracks.add(NetworkUtils.getNeatPathFromURI(t.getDataSource().getURI()));
            }
            this.setModel(new TrackComboModel(tracks.toArray(new String[0])));
            if (tracks.size() > 0) {
                if (this.selection != null) {
                    this.setSelectedItem(this.selection);
                }
                if (this.getSelectedIndex() < 0) {
                    this.setSelectedIndex(0);
                }
            }
        }

        private class TrackComboModel
        implements ComboBoxModel {
            private final String[] tracks;

            private TrackComboModel(String[] t) {
                this.tracks = t;
            }

            @Override
            public void setSelectedItem(Object o) {
                TrackCombo.this.selection = (String)o;
                ((TrackCombo)TrackCombo.this).argument.value = TrackCombo.this.selection;
                if (((TrackCombo)TrackCombo.this).argument.type == ToolArgument.Type.BAM_INPUT_FILE) {
                    ((ToolSettingsPanel)ToolSettingsPanel.this).tool.useHomoRefs = true;
                    String firstRef = ((BAMDataSourceAdapter)((Object)TrackUtils.getTrackDataSource(TrackCombo.this.selection))).getHeader().getSequence(0).getSequenceName();
                    if (firstRef.startsWith("chr")) {
                        ((ToolSettingsPanel)ToolSettingsPanel.this).tool.useHomoRefs = false;
                    }
                }
                ToolSettingsPanel.this.tool.displayCommandLine(ToolSettingsPanel.this.commandLine);
            }

            @Override
            public Object getSelectedItem() {
                return TrackCombo.this.selection;
            }

            @Override
            public int getSize() {
                return this.tracks.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.tracks[i];
            }

            @Override
            public void addListDataListener(ListDataListener ll) {
            }

            @Override
            public void removeListDataListener(ListDataListener ll) {
            }
        }
    }

    private class BoolCheck
    extends JCheckBox {
        private final ToolArgument argument;

        private BoolCheck(ToolArgument arg) {
            super(arg.name);
            this.argument = arg;
            this.setSelected(Boolean.getBoolean(arg.value));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ((BoolCheck)BoolCheck.this).argument.value = String.valueOf(BoolCheck.this.isSelected());
                }
            });
        }
    }

    private class EnablerCheckListener
    implements ActionListener {
        private final ToolArgument argument;
        private final JComponent[] widgets;

        EnablerCheckListener(ToolArgument arg, JComponent ... widgets) {
            this.argument = arg;
            for (JComponent w : this.widgets = widgets) {
                w.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            boolean enabled = ((JCheckBox)ae.getSource()).isSelected();
            for (JComponent w : this.widgets) {
                w.setEnabled(enabled);
                if (!enabled || !(w instanceof JTextField)) continue;
                ((JTextField)w).selectAll();
            }
            this.argument.enabled = enabled;
            ToolSettingsPanel.this.tool.displayCommandLine(ToolSettingsPanel.this.commandLine);
        }
    }
}

