/*
 * Decompiled with CFR 0.152.
 */
package savant.plugin.builtin;

import com.jidesoft.grid.TreeTable;
import com.jidesoft.swing.TableSearchable;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import savant.api.adapter.DataSourceAdapter;
import savant.api.util.DialogUtils;
import savant.plugin.builtin.AddSAFEGroup;
import savant.plugin.builtin.SAFELoginPanel;
import savant.settings.BrowserSettings;
import savant.settings.DirectorySettings;
import savant.util.MiscUtils;
import savant.util.NetworkUtils;
import savant.view.swing.model.TreeBrowserEntry;
import savant.view.swing.model.TreeBrowserModel;
import savant.view.tracks.TrackFactory;

public class SAFEBrowser
extends JDialog {
    private static final Log LOG = LogFactory.getLog(SAFEBrowser.class);
    private static final TableCellRenderer FILE_RENDERER = new FileRowCellRenderer();
    private Frame p;
    private TreeTable table;
    private URL trackPath = null;
    private static SAFEBrowser instance;
    private boolean loggedIn = false;
    private String username;
    private String password;
    private JPanel loginCard;
    private JPanel safeCard;
    private CardLayout layout;
    private JPanel container;

    public static SAFEBrowser getInstance() throws JDOMException, IOException {
        if (instance == null) {
            instance = new SAFEBrowser();
        }
        SAFEBrowser.instance.trackPath = null;
        return instance;
    }

    private SAFEBrowser() throws JDOMException, IOException {
        super(DialogUtils.getMainWindow(), "Savant File Exchange", Dialog.ModalityType.APPLICATION_MODAL);
        this.init();
    }

    private void actOnSelectedItem(boolean ignoreActionOnBranch) {
        TreeBrowserEntry r = (TreeBrowserEntry)this.table.getRowAt(this.table.getSelectedRow());
        if (r != null && r.isLeaf()) {
            try {
                LOG.debug((Object)("Setting track path to " + r.getURL().toString()));
                this.trackPath = r.getURL();
                this.closeDialog();
            }
            catch (Exception ex) {
                DialogUtils.displayMessage(String.format("Error opening URL %s: %s.", r.getURL(), MiscUtils.getMessage(ex)));
            }
        } else if (!ignoreActionOnBranch) {
            DialogUtils.displayMessage("Please select a track.");
        }
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    public DataSourceAdapter getDataSource() {
        if (this.trackPath == null) {
            LOG.error((Object)"Trackpath is null");
            return null;
        }
        try {
            DataSourceAdapter d = TrackFactory.createDataSource(this.trackPath.toURI(), null);
            return d;
        }
        catch (Exception ex) {
            LOG.error((Object)String.format("Unable to create data source for %s: %s.", this.trackPath, ex));
            return null;
        }
    }

    private static TreeBrowserEntry parseDocumentTreeRow(Element root) {
        if (root.getName().equals("branch")) {
            ArrayList<TreeBrowserEntry> children = new ArrayList<TreeBrowserEntry>();
            for (Object o : root.getChildren()) {
                Element c = (Element)o;
                children.add(SAFEBrowser.parseDocumentTreeRow(c));
            }
            return new TreeBrowserEntry(root.getAttributeValue("name"), children);
        }
        if (root.getName().equals("leaf")) {
            try {
                return new TreeBrowserEntry(root.getAttributeValue("name"), root.getChildText("type"), root.getChildText("description"), new URL(root.getChildText("url")), root.getChildText("size"));
            }
            catch (MalformedURLException x) {
                LOG.error((Object)x);
            }
        }
        return null;
    }

    private void init() {
        this.setDefaultCloseOperation(1);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.container = new JPanel();
        this.add((Component)this.container, "Center");
        this.layout = new CardLayout();
        this.container.setLayout(this.layout);
        this.loginCard = new SAFELoginPanel(this);
        this.safeCard = new JPanel();
        this.container.add((Component)this.loginCard, "login");
        this.container.add((Component)this.safeCard, "safe");
        this.setPreferredSize(new Dimension(800, 500));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void initSafe(final String username, final String password) throws MalformedURLException, JDOMException, IOException {
        this.safeCard.removeAll();
        this.safeCard.setLayout(new BorderLayout());
        File f = NetworkUtils.downloadFile(new URL(BrowserSettings.SAFE_URL + "?type=list&username=" + username + "&password=" + password), DirectorySettings.getTmpDirectory(), null);
        if (!this.wereCredentialsValid(f)) {
            DialogUtils.displayMessage("Login failed.");
            return;
        }
        Component mainp = this.getCenterPanel(SAFEBrowser.getDownloadTreeRows(f));
        this.safeCard.add(mainp, "Center");
        JMenuBar bottombar = new JMenuBar();
        bottombar.setAlignmentX(1.0f);
        bottombar.add(Box.createHorizontalGlue());
        JButton addgroupbutt = new JButton("Create group");
        addgroupbutt.putClientProperty("JButton.buttonType", "default");
        addgroupbutt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SAFEBrowser.addGroup(username, password);
                }
                catch (Exception ex) {
                    LOG.error((Object)("Unable to create group: " + ex.getLocalizedMessage()));
                }
            }
        });
        bottombar.add(addgroupbutt);
        JButton logoutbutt = new JButton("Logout");
        logoutbutt.putClientProperty("JButton.buttonType", "default");
        logoutbutt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SAFEBrowser.this.layout.show(SAFEBrowser.this.container, "login");
            }
        });
        bottombar.add(logoutbutt);
        JButton openbutt = new JButton("Load Track");
        openbutt.putClientProperty("JButton.buttonType", "default");
        openbutt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SAFEBrowser.this.actOnSelectedItem(false);
            }
        });
        bottombar.add(openbutt);
        this.safeCard.add((Component)bottombar, "South");
        this.layout.show(this.container, "safe");
    }

    private boolean wereCredentialsValid(File f) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String line = br.readLine();
            return line.contains("branch");
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void addGroup(String username, String password) {
        new AddSAFEGroup(DialogUtils.getMainWindow(), username, password).setVisible(true);
    }

    private static List<TreeBrowserEntry> getDownloadTreeRows(File f) throws JDOMException, IOException {
        ArrayList<TreeBrowserEntry> roots = new ArrayList<TreeBrowserEntry>();
        Document d = new SAXBuilder().build(f);
        Element root = d.getRootElement();
        TreeBrowserEntry treeroot = SAFEBrowser.parseDocumentTreeRow(root);
        roots.add(treeroot);
        return roots;
    }

    public final Component getCenterPanel(List<TreeBrowserEntry> roots) {
        this.table = new TreeTable((TableModel)((Object)new TreeBrowserModel(roots){

            @Override
            public String[] getColumnNames() {
                return new String[]{"Name", "Description"};
            }
        }));
        this.table.setSortable(false);
        this.table.setRespectRenderPreferredHeight(true);
        this.table.setExpandAllAllowed(true);
        this.table.setShowTreeLines(false);
        this.table.setSortingEnabled(false);
        this.table.setRowHeight(18);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setSelectionMode(0);
        this.table.expandFirstLevel();
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SAFEBrowser.this.actOnSelectedItem(true);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.table.setSelectRowWhenToggling(false);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(0).setCellRenderer(FILE_RENDERER);
        TableSearchable searchable = new TableSearchable((JTable)this.table){

            protected String convertElementToString(Object item) {
                if (item instanceof TreeBrowserEntry) {
                    return ((TreeBrowserEntry)item).getType();
                }
                return super.convertElementToString(item);
            }
        };
        searchable.setMainIndex(0);
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        scrollPane.getViewport().setBackground(Color.WHITE);
        JPanel panel = new JPanel(new BorderLayout(6, 6));
        panel.add((Component)scrollPane, "Center");
        panel.setPreferredSize(new Dimension(800, 500));
        return panel;
    }

    public static class FileRowCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof TreeBrowserEntry) {
                TreeBrowserEntry fileRow = (TreeBrowserEntry)value;
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, fileRow.getName(), isSelected, hasFocus, row, column);
                try {
                    label.setIcon(fileRow.getIcon());
                }
                catch (Exception e) {
                    // empty catch block
                }
                label.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
                return label;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

