/*
 * Decompiled with CFR 0.152.
 */
package savant.plugin.builtin;

import com.jidesoft.grid.TreeTable;
import com.jidesoft.swing.TableSearchable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.util.DialogUtils;
import savant.data.types.Genome;
import savant.util.NetworkUtils;
import savant.view.swing.model.TreeBrowserEntry;
import savant.view.swing.model.TreeBrowserModel;

public class SavantFileRepositoryBrowser
extends JDialog {
    private static final Log LOG = LogFactory.getLog(SavantFileRepositoryBrowser.class);
    private static final TableCellRenderer FILE_RENDERER = new FileRowCellRenderer();
    private TreeTable table;
    private URL trackPath = null;
    private static SavantFileRepositoryBrowser instance;

    public static SavantFileRepositoryBrowser getInstance() {
        if (instance == null) {
            instance = new SavantFileRepositoryBrowser(DialogUtils.getMainWindow());
        }
        SavantFileRepositoryBrowser.instance.trackPath = null;
        return instance;
    }

    private SavantFileRepositoryBrowser(Window parent) {
        super(parent, "Public Savant File Repository Browser", Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(1);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.add(this.getCenterPanel(SavantFileRepositoryBrowser.getDownloadTreeRows()), "Center");
        JMenuBar bottombar = new JMenuBar();
        bottombar.setAlignmentX(1.0f);
        bottombar.add(Box.createHorizontalGlue());
        JButton openbutt = new JButton("Load Track");
        openbutt.putClientProperty("JButton.buttonType", "default");
        openbutt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavantFileRepositoryBrowser.this.actOnSelectedItem(false);
            }
        });
        bottombar.add(openbutt);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.putClientProperty("JButton.buttonType", "default");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavantFileRepositoryBrowser.this.closeDialog();
            }
        });
        bottombar.add(cancelButton);
        this.add((Component)bottombar, "South");
        this.setPreferredSize(new Dimension(800, 500));
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void actOnSelectedItem(boolean ignoreActionOnBranch) {
        TreeBrowserEntry r = (TreeBrowserEntry)this.table.getRowAt(this.table.getSelectedRow());
        if (r != null && r.isLeaf()) {
            try {
                LOG.info((Object)("Setting track path to " + r.getURL()));
                this.trackPath = r.getURL();
                this.closeDialog();
            }
            catch (Exception ex) {
                DialogUtils.displayMessage(String.format("Error opening URL %s: %s.", r.getURL(), ex));
            }
        } else if (!ignoreActionOnBranch) {
            DialogUtils.displayMessage("Please select a track.");
        }
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    public URL getTrackPath() {
        return this.trackPath;
    }

    private static List<TreeBrowserEntry> getDownloadTreeRows() {
        Genome[] genomes = Genome.getDefaultGenomes();
        ArrayList<TreeBrowserEntry> roots = new ArrayList<TreeBrowserEntry>(genomes.length);
        try {
            for (Genome g : genomes) {
                Genome.Auxiliary[] auxes = g.getAuxiliaries();
                if (auxes.length <= 0) continue;
                ArrayList<TreeBrowserEntry> auxEntries = new ArrayList<TreeBrowserEntry>(auxes.length);
                for (Genome.Auxiliary aux : g.getAuxiliaries()) {
                    auxEntries.add(new TreeBrowserEntry(NetworkUtils.getFileName(aux.uri), aux.type.toString(), aux.description, aux.uri.toURL(), "0"));
                }
                roots.add(new TreeBrowserEntry(g.getDescription(), auxEntries));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return roots;
    }

    public final Component getCenterPanel(List<TreeBrowserEntry> roots) {
        this.table = new TreeTable((TableModel)((Object)new TreeBrowserModel(roots){

            @Override
            public String[] getColumnNames() {
                return new String[]{"Name", "Description"};
            }
        }));
        this.table.setSortable(true);
        this.table.setRespectRenderPreferredHeight(true);
        this.table.setExpandAllAllowed(true);
        this.table.setShowTreeLines(false);
        this.table.setSortingEnabled(false);
        this.table.setRowHeight(18);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setSelectionMode(0);
        this.table.expandFirstLevel();
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SavantFileRepositoryBrowser.this.actOnSelectedItem(true);
                }
            }
        });
        this.table.setSelectRowWhenToggling(false);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(0).setCellRenderer(FILE_RENDERER);
        TableSearchable searchable = new TableSearchable((JTable)this.table){

            protected String convertElementToString(Object item) {
                if (item instanceof TreeBrowserEntry) {
                    return ((TreeBrowserEntry)item).getType();
                }
                return super.convertElementToString(item);
            }
        };
        searchable.setMainIndex(0);
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        scrollPane.getViewport().setBackground(Color.WHITE);
        JPanel panel = new JPanel(new BorderLayout(6, 6));
        panel.add((Component)scrollPane, "Center");
        panel.setPreferredSize(new Dimension(800, 500));
        return panel;
    }

    private static class FileRowCellRenderer
    extends DefaultTableCellRenderer {
        private FileRowCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof TreeBrowserEntry) {
                TreeBrowserEntry fileRow = (TreeBrowserEntry)value;
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, fileRow.getName(), isSelected, hasFocus, row, column);
                try {
                    label.setIcon(fileRow.getIcon());
                }
                catch (Exception e) {
                    // empty catch block
                }
                label.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
                return label;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

