/*
 * Decompiled with CFR 0.152.
 */
package savant.selection;

import java.util.Map;
import javax.swing.JLabel;
import savant.api.adapter.DataSourceAdapter;
import savant.data.types.GFFIntervalRecord;
import savant.data.types.TabixIntervalRecord;
import savant.selection.PopupPanel;

public class TabixPopup
extends PopupPanel {
    private String[] columnNames;

    public TabixPopup(DataSourceAdapter dataSource) {
        this.columnNames = dataSource.getColumnNames();
    }

    @Override
    protected void initInfo() {
        TabixIntervalRecord rec = (TabixIntervalRecord)this.record;
        this.name = rec.getName();
        this.ref = rec.getReference();
        this.start = rec.getInterval().getStart();
        this.end = rec.getInterval().getEnd();
        String[] values = rec.getValues();
        boolean gff = rec instanceof GFFIntervalRecord;
        for (int i = 0; i < this.columnNames.length && i < values.length; ++i) {
            if (this.columnNames[i] == null || gff && i == 8) continue;
            this.add(new JLabel(this.columnNames[i] + ":\t" + values[i]));
        }
        if (gff) {
            Map<String, String> attributes = ((GFFIntervalRecord)rec).getAttributes();
            for (String k : attributes.keySet()) {
                this.add(new JLabel(k + ":\t" + attributes.get(k)));
            }
        }
    }

    @Override
    protected void initSpecificButtons() {
        this.initIntervalJumps();
    }
}

