/*
 * Decompiled with CFR 0.152.
 */
package savant.selection;

import java.util.List;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import org.apache.commons.lang3.StringUtils;
import savant.api.data.VariantRecord;
import savant.selection.PopupPanel;
import savant.view.variation.LDRecord;
import savant.view.variation.ParticipantRecord;
import savant.view.variation.VariationController;

public class VariantPopup
extends PopupPanel {
    VariantPopup() {
    }

    @Override
    protected void initInfo() {
        if (this.record instanceof LDRecord) {
            LDRecord ldRec = (LDRecord)this.record;
            float dPrime = ldRec.getDPrime();
            if (!Float.isNaN(dPrime)) {
                this.add(new JLabel(String.format("D\u2032: %.2f", Float.valueOf(dPrime))));
            }
            this.add(new JLabel(String.format("r\u00b2: %.2f", Float.valueOf(ldRec.getRSquared()))));
            List<VariantRecord> varRecs = ldRec.getConstituents();
            VariantRecord varRec0 = varRecs.get(0);
            VariantRecord varRec1 = varRecs.get(1);
            this.add(new JSeparator());
            this.initVariantRecord(varRec0, null);
            this.add(new JSeparator());
            this.initVariantRecord(varRec1, null);
            this.name = VariationController.getDisplayName(varRec0) + " vs. " + VariationController.getDisplayName(varRec1);
            this.start = Math.min(varRec0.getPosition(), varRec1.getPosition());
            this.end = Math.max(varRec0.getPosition(), varRec1.getPosition());
        } else {
            VariantRecord varRec;
            ParticipantRecord partRec = null;
            if (this.record instanceof VariantRecord) {
                varRec = (VariantRecord)this.record;
            } else {
                partRec = (ParticipantRecord)this.record;
                varRec = partRec.getVariantRecord();
            }
            this.name = varRec.getName();
            this.start = this.end = varRec.getPosition();
            this.initVariantRecord(varRec, partRec);
        }
    }

    private void initVariantRecord(VariantRecord varRec, ParticipantRecord partRec) {
        if (varRec.getName() != null) {
            this.add(new JLabel("Variant Name: " + varRec.getName()));
        }
        this.add(new JLabel("Type: " + varRec.getVariantType().getDescription()));
        this.add(new JLabel("Position: " + varRec.getPosition()));
        this.add(new PopupPanel.PopupLabel(this, "Reference: " + varRec.getRefBases()));
        if (partRec == null) {
            this.add(new PopupPanel.PopupLabel(this, "Alt: " + StringUtils.join((Object[])varRec.getAltAlleles(), (char)',')));
        } else {
            this.add(new JSeparator());
            this.add(new JLabel("Participant: " + partRec.getName()));
            this.add(new PopupPanel.PopupLabel(this, "Alleles: " + StringUtils.join((Object[])partRec.getAlleles(), (char)',')));
        }
    }
}

