/*
 * Decompiled with CFR 0.152.
 */
package savant.settings;

import com.apple.eio.FileManager;
import java.io.File;
import savant.settings.PersistentSettings;
import savant.util.MiscUtils;

public class DirectorySettings {
    private static PersistentSettings settings = PersistentSettings.getInstance();
    private static File savantDir;
    private static final String CACHE_DIR_KEY = "CacheDir";
    private static final String PLUGINS_DIR_KEY = "PluginsDir";
    private static final String PROJECTS_DIR_KEY = "ProjectsDir";

    public static File getSavantDirectory() {
        if (savantDir == null) {
            File f = new File(System.getProperty("user.home"), MiscUtils.WINDOWS ? "savant" : ".savant");
            if (!f.exists()) {
                f.mkdir();
            }
            savantDir = f;
        }
        return savantDir;
    }

    public static File getLibsDirectory() {
        File result;
        if (MiscUtils.MAC && (result = new File(FileManager.getPathToApplicationBundle() + "/Contents/Resources/Java")).exists()) {
            return result;
        }
        return new File("lib");
    }

    private static File getDirectory(String key, String dirName) {
        File result = settings.getFile(key);
        if (result == null) {
            result = new File(DirectorySettings.getSavantDirectory(), dirName);
        }
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    private static void setDirectory(String key, File value) {
        if (!value.exists()) {
            value.mkdirs();
        }
        settings.setFile(key, value);
    }

    public static File getCacheDirectory() {
        return DirectorySettings.getDirectory(CACHE_DIR_KEY, "cache");
    }

    public static File getPluginsDirectory() {
        return DirectorySettings.getDirectory(PLUGINS_DIR_KEY, "plugins");
    }

    public static File getProjectsDirectory() {
        return DirectorySettings.getDirectory(PROJECTS_DIR_KEY, "projects");
    }

    public static File getTmpDirectory() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static void setPluginsDirectory(File dir) {
        DirectorySettings.setDirectory(PLUGINS_DIR_KEY, dir);
    }

    public static void setCacheDirectory(File dir) {
        DirectorySettings.setDirectory(CACHE_DIR_KEY, dir);
    }
}

