/*
 * Decompiled with CFR 0.152.
 */
package savant.settings;

import java.awt.GridBagConstraints;
import java.io.IOException;
import javax.swing.JCheckBox;
import savant.settings.BrowserSettings;
import savant.settings.PersistentSettings;
import savant.settings.Section;
import savant.settings.SettingsDialog;

public class GeneralSettingsSection
extends Section {
    JCheckBox checkversion_cb;
    JCheckBox collectrstats_cb;
    private JCheckBox startpage_cb;

    public String getTitle() {
        return "General Settings";
    }

    public void lazyInitialize() {
        this.add(SettingsDialog.getHeader(this.getTitle()), this.getFullRowConstraints());
        this.checkversion_cb = new JCheckBox("Check version on startup");
        this.checkversion_cb.setSelected(BrowserSettings.getCheckVersionOnStartup());
        this.checkversion_cb.addActionListener(this.enablingActionListener);
        this.add(this.checkversion_cb, this.getFullRowConstraints());
        this.startpage_cb = new JCheckBox("Show Start Page");
        this.startpage_cb.setSelected(BrowserSettings.getShowStartPage());
        this.startpage_cb.addActionListener(this.enablingActionListener);
        this.add(this.startpage_cb, this.getFullRowConstraints());
        this.collectrstats_cb = new JCheckBox("Collect anonymous statistics about usage");
        this.collectrstats_cb.setSelected(BrowserSettings.getCollectAnonymousUsage());
        this.collectrstats_cb.addActionListener(this.enablingActionListener);
        GridBagConstraints gbc = this.getFullRowConstraints();
        gbc.fill = 0;
        gbc.weighty = 1.0;
        this.add(this.collectrstats_cb, gbc);
    }

    @Override
    public void applyChanges() {
        if (this.checkversion_cb != null) {
            BrowserSettings.setCheckVersionOnStartup(this.checkversion_cb.isSelected());
            BrowserSettings.setShowStartPage(this.startpage_cb.isSelected());
            BrowserSettings.setCollectAnonymousUsage(this.collectrstats_cb.isSelected());
            try {
                PersistentSettings.getInstance().store();
            }
            catch (IOException iox) {
                this.LOG.error((Object)"Unable to save general settings.", (Throwable)iox);
            }
        }
    }
}

