/*
 * Decompiled with CFR 0.152.
 */
package savant.settings;

import savant.api.data.DataFormat;
import savant.settings.PersistentSettings;

public class InterfaceSettings {
    private static final PersistentSettings SETTINGS = PersistentSettings.getInstance();
    private static final int BAM_INTERVAL_HEIGHT = 12;
    private static final int RICH_INTERVAL_HEIGHT = 16;
    private static final int GENERIC_INTERVAL_HEIGHT = 12;
    private static final String BAM_INTERVAL_HEIGHT_KEY = "BamIntervalHeight";
    private static final String RICH_INTERVAL_HEIGHT_KEY = "RichIntervalHeight";
    private static final String GENERIC_INTERVAL_HEIGHT_KEY = "GenericIntervalHeight";
    private static final String POPUPS_DISABLED_KEY = "PopupsDisabled";
    private static final String LEGENDS_DISABLED_KEY = "LegendsDisabled";
    private static final String WHEEL_ZOOMS_KEY = "WheelZooms";

    public static int getBamIntervalHeight() {
        return SETTINGS.getInt(BAM_INTERVAL_HEIGHT_KEY, 12);
    }

    public static int getRichIntervalHeight() {
        return SETTINGS.getInt(RICH_INTERVAL_HEIGHT_KEY, 16);
    }

    public static int getGenericIntervalHeight() {
        return SETTINGS.getInt(GENERIC_INTERVAL_HEIGHT_KEY, 12);
    }

    public static int getIntervalHeight(DataFormat type) {
        switch (type) {
            case ALIGNMENT: {
                return InterfaceSettings.getBamIntervalHeight();
            }
            case RICH_INTERVAL: {
                return InterfaceSettings.getRichIntervalHeight();
            }
        }
        return InterfaceSettings.getGenericIntervalHeight();
    }

    public static void setBamIntervalHeight(int value) {
        SETTINGS.setInt(BAM_INTERVAL_HEIGHT_KEY, value);
    }

    public static void setRichIntervalHeight(int value) {
        SETTINGS.setInt(RICH_INTERVAL_HEIGHT_KEY, value);
    }

    public static void setGenericIntervalHeight(int value) {
        SETTINGS.setInt(GENERIC_INTERVAL_HEIGHT_KEY, value);
    }

    public static boolean areLegendsDisabled() {
        return SETTINGS.getBoolean(LEGENDS_DISABLED_KEY, false);
    }

    public static void setLegendsDisabled(boolean value) {
        SETTINGS.setBoolean(LEGENDS_DISABLED_KEY, value);
    }

    public static boolean arePopupsDisabled() {
        return SETTINGS.getBoolean(POPUPS_DISABLED_KEY, false);
    }

    public static void setPopupsDisabled(boolean value) {
        SETTINGS.setBoolean(POPUPS_DISABLED_KEY, value);
    }

    public static boolean doesWheelZoom() {
        return SETTINGS.getBoolean(WHEEL_ZOOMS_KEY, true);
    }

    public static void setWheelZooms(boolean value) {
        SETTINGS.setBoolean(WHEEL_ZOOMS_KEY, value);
    }
}

