/*
 * Decompiled with CFR 0.152.
 */
package savant.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import savant.settings.BrowserSettings;
import savant.settings.DirectorySettings;
import savant.settings.PersistentSettings;
import savant.settings.Section;
import savant.settings.SettingsDialog;
import savant.util.RemoteFileCache;

public class RemoteFilesSettingsSection
extends Section {
    private JTextField directoryInput;
    private JTextField buffSizeInput;
    private String buffSize;
    private File cacheDir;
    JCheckBox enableCaching_cb;

    public String getTitle() {
        return "Remote Files";
    }

    public void lazyInitialize() {
        GridBagConstraints gbc = this.getFullRowConstraints();
        this.add(SettingsDialog.getHeader(this.getTitle()), gbc);
        this.enableCaching_cb = new JCheckBox("Enable remote file caching ");
        this.enableCaching_cb.setSelected(BrowserSettings.getCachingEnabled());
        this.enableCaching_cb.addActionListener(this.enablingActionListener);
        this.add(this.enableCaching_cb, gbc);
        JLabel directoryLabel = new JLabel("Select the folder to store cached files: ");
        this.add(directoryLabel, gbc);
        this.directoryInput = new JTextField();
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.insets.bottom = 12;
        this.add(this.directoryInput, gbc);
        JButton directoryBrowse = new JButton("Browse...");
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        this.add(directoryBrowse, gbc);
        this.cacheDir = DirectorySettings.getCacheDirectory();
        this.directoryInput.setText(this.cacheDir.getAbsolutePath());
        this.directoryInput.addKeyListener(this.enablingKeyListener);
        directoryBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                int returnVal = fc.showOpenDialog((Component)((Object)RemoteFilesSettingsSection.this));
                if (returnVal == -1) {
                    return;
                }
                RemoteFilesSettingsSection.this.directoryInput.setText(fc.getSelectedFile().getAbsolutePath());
                RemoteFilesSettingsSection.this.enableApplyButton();
            }
        });
        JLabel buffSizeLabel = new JLabel("Select buffer size (bytes): ");
        gbc = this.getFullRowConstraints();
        this.add(buffSizeLabel, gbc);
        this.buffSizeInput = new JTextField();
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.insets.bottom = 12;
        this.add(this.buffSizeInput, gbc);
        JButton defaultSizeButton = new JButton("Default");
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        this.add(defaultSizeButton, gbc);
        this.buffSize = String.valueOf(BrowserSettings.getRemoteBufferSize());
        this.buffSizeInput.setText(this.buffSize);
        this.buffSizeInput.addKeyListener(this.enablingKeyListener);
        defaultSizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteFilesSettingsSection.this.buffSizeInput.setText(String.valueOf(65536));
                RemoteFilesSettingsSection.this.enableApplyButton();
            }
        });
        JButton clearButton = new JButton("Clear remote file cache");
        gbc = this.getFullRowConstraints();
        gbc.weighty = 1.0;
        gbc.fill = 0;
        this.add(clearButton, gbc);
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteFileCache.clearCache();
            }
        });
    }

    @Override
    public void applyChanges() {
        if (this.directoryInput != null) {
            int newVal;
            this.cacheDir = new File(this.directoryInput.getText());
            DirectorySettings.setCacheDirectory(this.cacheDir);
            this.buffSize = this.buffSizeInput.getText();
            try {
                newVal = Integer.parseInt(this.buffSize);
            }
            catch (NumberFormatException e) {
                newVal = 65536;
            }
            newVal = Math.max(newVal, 1024);
            this.buffSizeInput.setText(String.valueOf(newVal));
            BrowserSettings.setRemoteBufferSize(newVal);
            BrowserSettings.setCachingEnabled(this.enableCaching_cb.isSelected());
            try {
                PersistentSettings.getInstance().store();
            }
            catch (IOException iox) {
                this.LOG.error((Object)"Unable to save remote file settings.", (Throwable)iox);
            }
        }
    }
}

