/*
 * Decompiled with CFR 0.152.
 */
package savant.settings;

import savant.settings.PersistentSettings;

public class ResolutionSettings {
    private static final PersistentSettings SETTINGS = PersistentSettings.getInstance();
    private static final int SEQUENCE_LOW_TO_HIGH_DEFAULT = 10000;
    private static final int INTERVAL_LOW_TO_HIGH_DEFAULT = 1000000;
    private static final int BAM_LOW_TO_HIGH_DEFAULT = 20000;
    private static final int BAM_ARC_LOW_TO_HIGH_DEFAULT = 100000;
    private static final int CONTINUOUS_LOW_TO_HIGH_DEFAULT = 10000;
    private static final int VARIANT_LOW_TO_HIGH_DEFAULT = 1000000;
    private static final int LD_MAX_LOCI_DEFAULT = 500;
    private static final String SEQUENCE_LOW_TO_HIGH_KEY = "SequenceLowToHigh";
    private static final String INTERVAL_LOW_TO_HIGH_KEY = "IntervalLowToHigh";
    private static final String BAM_LOW_TO_HIGH_KEY = "BAMLowToHigh";
    private static final String BAM_ARC_LOW_TO_HIGH_KEY = "BAMArcLowToHigh";
    private static final String CONSERVATION_LOW_TO_HIGH_KEY = "ConservationLowToHigh";
    private static final String VARIANT_LOW_TO_HIGH_KEY = "VariantLowToHigh";
    private static final String LD_MAX_LOCI_KEY = "LDMaxLoci";

    public static int getBAMArcModeLowToHighThreshold() {
        return SETTINGS.getInt(BAM_ARC_LOW_TO_HIGH_KEY, 100000);
    }

    public static void setBAMArcModeLowToHighThreshold(int value) {
        SETTINGS.setInt(BAM_ARC_LOW_TO_HIGH_KEY, value);
    }

    public static int getBAMLowToHighThreshold() {
        return SETTINGS.getInt(BAM_LOW_TO_HIGH_KEY, 20000);
    }

    public static void setBAMLowToHighThreshold(int value) {
        SETTINGS.setInt(BAM_LOW_TO_HIGH_KEY, value);
    }

    public static int getIntervalLowToHighThreshold() {
        return SETTINGS.getInt(INTERVAL_LOW_TO_HIGH_KEY, 1000000);
    }

    public static void setIntervalLowToHighThreshold(int value) {
        SETTINGS.setInt(INTERVAL_LOW_TO_HIGH_KEY, value);
    }

    public static int getSequenceLowToHighThreshold() {
        return SETTINGS.getInt(SEQUENCE_LOW_TO_HIGH_KEY, 10000);
    }

    public static void setSequenceLowToHighThreshold(int value) {
        SETTINGS.setInt(SEQUENCE_LOW_TO_HIGH_KEY, value);
    }

    public static int getContinuousLowToHighThreshold() {
        return SETTINGS.getInt(CONSERVATION_LOW_TO_HIGH_KEY, 10000);
    }

    public static void setContinuousLowToHighThreshold(int value) {
        SETTINGS.setInt(CONSERVATION_LOW_TO_HIGH_KEY, value);
    }

    public static int getVariantLowToHighThreshold() {
        return SETTINGS.getInt(VARIANT_LOW_TO_HIGH_KEY, 1000000);
    }

    public static void setVariantLowToHighThreshold(int value) {
        SETTINGS.setInt(VARIANT_LOW_TO_HIGH_KEY, value);
    }

    public static int getLDMaxLoci() {
        return SETTINGS.getInt(LD_MAX_LOCI_KEY, 500);
    }

    public static void setLDMaxLoci(int value) {
        SETTINGS.setInt(LD_MAX_LOCI_KEY, value);
    }
}

